/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class DiagonalKB
extends TestKB {
    private static final Label key = Label.of((String)"name");
    private static final String gqlFile = "diagonal-test.gql";
    private final int n;
    private final int m;

    public DiagonalKB(int n, int m) {
        this.m = m;
        this.n = n;
    }

    public static Consumer<GraknTx> get(int n, int m) {
        return new DiagonalKB(n, m).build();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBContext.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n, this.m);
        };
    }

    private void buildExtensionalDB(GraknTx tx, int n, int m) {
        int j;
        int i;
        Role relFrom = tx.getRole("rel-from");
        Role relTo = tx.getRole("rel-to");
        EntityType entity1 = tx.getEntityType("entity1");
        RelationshipType horizontal = tx.getRelationshipType("horizontal");
        RelationshipType vertical = tx.getRelationshipType("vertical");
        ConceptId[][] instanceIds = new ConceptId[n][m];
        long inserts = 0L;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                instanceIds[i][j] = DiagonalKB.putEntity(tx, "a" + i + "," + j, entity1, key).getId();
                if (++inserts % 100L != 0L) continue;
                System.out.println("inst inserts: " + inserts);
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                if (i < n - 1) {
                    vertical.addRelationship().addRolePlayer(relFrom, (Thing)tx.getConcept(instanceIds[i][j])).addRolePlayer(relTo, (Thing)tx.getConcept(instanceIds[i + 1][j]));
                    ++inserts;
                }
                if (j < m - 1) {
                    horizontal.addRelationship().addRolePlayer(relFrom, (Thing)tx.getConcept(instanceIds[i][j])).addRolePlayer(relTo, (Thing)tx.getConcept(instanceIds[i][j + 1]));
                    ++inserts;
                }
                if (inserts % 100L != 0L) continue;
                System.out.println("rel inserts: " + inserts);
            }
        }
        System.out.println("Extensional DB loaded.");
    }
}

