/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class MatrixKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "matrix-test.gql";
    private final int n;
    private final int m;

    public MatrixKB(int n, int m) {
        this.m = m;
        this.n = n;
    }

    public static Consumer<GraknTx> get(int n, int m) {
        return new MatrixKB(n, m).build();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBContext.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n, this.m);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n, int m) {
        int i;
        Role R1from = graph.getRole("R1-from");
        Role R1to = graph.getRole("R1-to");
        Role R2from = graph.getRole("R2-from");
        Role R2to = graph.getRole("R2-to");
        EntityType aEntity = graph.getEntityType("a-entity");
        EntityType bEntity = graph.getEntityType("b-entity");
        RelationshipType R1 = graph.getRelationshipType("R1");
        RelationshipType R2 = graph.getRelationshipType("R2");
        ConceptId[] aInstancesIds = new ConceptId[m + 1];
        ConceptId[][] bInstancesIds = new ConceptId[m][n + 1];
        aInstancesIds[0] = MatrixKB.putEntity(graph, "a0", graph.getEntityType("start"), key).getId();
        aInstancesIds[m] = MatrixKB.putEntity(graph, "a" + m, graph.getEntityType("end"), key).getId();
        for (i = 1; i < m; ++i) {
            aInstancesIds[i] = MatrixKB.putEntity(graph, "a" + i, aEntity, key).getId();
        }
        for (i = 1; i < m; ++i) {
            for (int j = 1; j <= n; ++j) {
                bInstancesIds[i][j] = MatrixKB.putEntity(graph, "b" + i + j, bEntity, key).getId();
            }
        }
        for (i = 0; i < m; ++i) {
            R1.addRelationship().addRolePlayer(R1from, (Thing)graph.getConcept(aInstancesIds[i])).addRolePlayer(R1to, (Thing)graph.getConcept(aInstancesIds[i + 1]));
        }
        for (int j = 1; j <= n; ++j) {
            R2.addRelationship().addRolePlayer(R2from, (Thing)graph.getConcept(aInstancesIds[0])).addRolePlayer(R2to, (Thing)graph.getConcept(bInstancesIds[1][j]));
            R2.addRelationship().addRolePlayer(R2from, (Thing)graph.getConcept(bInstancesIds[m - 1][j])).addRolePlayer(R2to, (Thing)graph.getConcept(aInstancesIds[m]));
            for (int i2 = 1; i2 < m - 1; ++i2) {
                R2.addRelationship().addRolePlayer(R2from, (Thing)graph.getConcept(bInstancesIds[i2][j])).addRolePlayer(R2to, (Thing)graph.getConcept(bInstancesIds[i2 + 1][j]));
            }
        }
    }
}

