/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.graql.Pattern;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.util.Schema;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.function.Consumer;

public class MovieKB
extends TestKB {
    private static EntityType production;
    private static EntityType movie;
    private static EntityType person;
    private static EntityType genre;
    private static EntityType character;
    private static EntityType cluster;
    private static EntityType language;
    private static AttributeType<String> title;
    private static AttributeType<String> gender;
    private static AttributeType<String> realName;
    private static AttributeType<String> name;
    private static AttributeType<String> provenance;
    private static AttributeType<Long> tmdbVoteCount;
    private static AttributeType<Long> runtime;
    private static AttributeType<Double> tmdbVoteAverage;
    private static AttributeType<LocalDateTime> releaseDate;
    private static RelationshipType hasCast;
    private static RelationshipType authoredBy;
    private static RelationshipType directedBy;
    private static RelationshipType hasGenre;
    private static RelationshipType hasCluster;
    private static Role productionBeingDirected;
    private static Role director;
    private static Role productionWithCast;
    private static Role actor;
    private static Role characterBeingPlayed;
    private static Role genreOfProduction;
    private static Role productionWithGenre;
    private static Role clusterOfProduction;
    private static Role productionWithCluster;
    private static Role work;
    private static Role author;
    private static Thing godfather;
    private static Thing theMuppets;
    private static Thing heat;
    private static Thing apocalypseNow;
    private static Thing hocusPocus;
    private static Thing spy;
    private static Thing chineseCoffee;
    private static Thing marlonBrando;
    private static Thing alPacino;
    private static Thing missPiggy;
    private static Thing kermitTheFrog;
    private static Thing martinSheen;
    private static Thing robertDeNiro;
    private static Thing judeLaw;
    private static Thing mirandaHeart;
    private static Thing betteMidler;
    private static Thing sarahJessicaParker;
    private static Thing crime;
    private static Thing drama;
    private static Thing war;
    private static Thing action;
    private static Thing comedy;
    private static Thing family;
    private static Thing musical;
    private static Thing fantasy;
    private static Thing donVitoCorleone;
    private static Thing michaelCorleone;
    private static Thing colonelWalterEKurtz;
    private static Thing benjaminLWillard;
    private static Thing ltVincentHanna;
    private static Thing neilMcCauley;
    private static Thing bradleyFine;
    private static Thing nancyBArtingstall;
    private static Thing winifred;
    private static Thing sarah;
    private static Thing harry;
    private static Thing cluster0;
    private static Thing cluster1;

    public static Consumer<GraknTx> get() {
        return new MovieKB().build();
    }

    @Override
    public void buildSchema(GraknTx tx) {
        work = tx.putRole("work");
        author = tx.putRole("author");
        authoredBy = tx.putRelationshipType("authored-by").relates(work).relates(author);
        productionBeingDirected = tx.putRole("production-being-directed").sup(work);
        director = tx.putRole("director").sup(author);
        directedBy = tx.putRelationshipType("directed-by").sup(authoredBy).relates(productionBeingDirected).relates(director);
        productionWithCast = tx.putRole("production-with-cast");
        actor = tx.putRole("actor");
        characterBeingPlayed = tx.putRole("character-being-played");
        hasCast = tx.putRelationshipType("has-cast").relates(productionWithCast).relates(actor).relates(characterBeingPlayed);
        genreOfProduction = tx.putRole("genre-of-production");
        productionWithGenre = tx.putRole("production-with-genre");
        hasGenre = tx.putRelationshipType("has-genre").relates(genreOfProduction).relates(productionWithGenre);
        clusterOfProduction = tx.putRole("cluster-of-production");
        productionWithCluster = tx.putRole("production-with-cluster");
        hasCluster = tx.putRelationshipType("has-cluster").relates(clusterOfProduction).relates(productionWithCluster);
        title = tx.putAttributeType("title", AttributeType.DataType.STRING);
        title.attribute(title);
        tmdbVoteCount = tx.putAttributeType("tmdb-vote-count", AttributeType.DataType.LONG);
        tmdbVoteAverage = tx.putAttributeType("tmdb-vote-average", AttributeType.DataType.DOUBLE);
        releaseDate = tx.putAttributeType("release-date", AttributeType.DataType.DATE);
        runtime = tx.putAttributeType("runtime", AttributeType.DataType.LONG);
        gender = tx.putAttributeType("gender", AttributeType.DataType.STRING).setRegex("(fe)?male");
        realName = tx.putAttributeType("real-name", AttributeType.DataType.STRING);
        name = tx.putAttributeType("name", AttributeType.DataType.STRING);
        provenance = tx.putAttributeType("provenance", AttributeType.DataType.STRING);
        production = tx.putEntityType("production").plays(productionWithCluster).plays(productionBeingDirected).plays(productionWithCast).plays(productionWithGenre);
        production.attribute(title);
        production.attribute(tmdbVoteCount);
        production.attribute(tmdbVoteAverage);
        production.attribute(releaseDate);
        production.attribute(runtime);
        movie = tx.putEntityType("movie").sup(production);
        tx.putEntityType("tv-show").sup(production);
        person = tx.putEntityType("person").plays(director).plays(actor).plays(characterBeingPlayed);
        person.attribute(gender);
        person.attribute(name);
        person.attribute(realName);
        genre = tx.putEntityType("genre").plays(genreOfProduction);
        genre.key(name);
        character = tx.putEntityType("character").plays(characterBeingPlayed);
        character.attribute(name);
        tx.putEntityType("award");
        language = tx.putEntityType("language");
        language.attribute(name);
        cluster = tx.putEntityType("cluster").plays(clusterOfProduction);
        cluster.attribute(name);
        tx.getType(Schema.ImplicitType.HAS.getLabel("title")).attribute(provenance);
    }

    @Override
    protected void buildInstances(GraknTx tx) {
        godfather = movie.addEntity();
        MovieKB.putResource(godfather, title, "Godfather");
        MovieKB.putResource(godfather, tmdbVoteCount, 1000L);
        MovieKB.putResource(godfather, tmdbVoteAverage, 8.6);
        MovieKB.putResource(godfather, releaseDate, LocalDate.of(1984, 1, 1).atStartOfDay());
        theMuppets = movie.addEntity();
        MovieKB.putResource(theMuppets, title, "The Muppets");
        MovieKB.putResource(theMuppets, tmdbVoteCount, 100L);
        MovieKB.putResource(theMuppets, tmdbVoteAverage, 7.6);
        MovieKB.putResource(theMuppets, releaseDate, LocalDate.of(1985, 2, 2).atStartOfDay());
        apocalypseNow = movie.addEntity();
        MovieKB.putResource(apocalypseNow, title, "Apocalypse Now");
        MovieKB.putResource(apocalypseNow, tmdbVoteCount, 400L);
        MovieKB.putResource(apocalypseNow, tmdbVoteAverage, 8.4);
        heat = movie.addEntity();
        MovieKB.putResource(heat, title, "Heat");
        hocusPocus = movie.addEntity();
        MovieKB.putResource(hocusPocus, title, "Hocus Pocus");
        MovieKB.putResource(hocusPocus, tmdbVoteCount, 435L);
        spy = movie.addEntity();
        MovieKB.putResource(spy, title, "Spy");
        MovieKB.putResource(spy, releaseDate, LocalDate.of(1986, 3, 3).atStartOfDay());
        chineseCoffee = movie.addEntity();
        MovieKB.putResource(chineseCoffee, title, "Chinese Coffee");
        MovieKB.putResource(chineseCoffee, tmdbVoteCount, 5L);
        MovieKB.putResource(chineseCoffee, tmdbVoteAverage, 3.1);
        MovieKB.putResource(chineseCoffee, releaseDate, LocalDate.of(2000, 9, 2).atStartOfDay());
        marlonBrando = person.addEntity();
        MovieKB.putResource(marlonBrando, name, "Marlon Brando");
        alPacino = person.addEntity();
        MovieKB.putResource(alPacino, name, "Al Pacino");
        missPiggy = person.addEntity();
        MovieKB.putResource(missPiggy, name, "Miss Piggy");
        kermitTheFrog = person.addEntity();
        MovieKB.putResource(kermitTheFrog, name, "Kermit The Frog");
        martinSheen = person.addEntity();
        MovieKB.putResource(martinSheen, name, "Martin Sheen");
        robertDeNiro = person.addEntity();
        MovieKB.putResource(robertDeNiro, name, "Robert de Niro");
        judeLaw = person.addEntity();
        MovieKB.putResource(judeLaw, name, "Jude Law");
        mirandaHeart = person.addEntity();
        MovieKB.putResource(mirandaHeart, name, "Miranda Heart");
        betteMidler = person.addEntity();
        MovieKB.putResource(betteMidler, name, "Bette Midler");
        sarahJessicaParker = person.addEntity();
        MovieKB.putResource(sarahJessicaParker, name, "Sarah Jessica Parker");
        crime = genre.addEntity();
        MovieKB.putResource(crime, name, "crime");
        drama = genre.addEntity();
        MovieKB.putResource(drama, name, "drama");
        war = genre.addEntity();
        MovieKB.putResource(war, name, "war");
        action = genre.addEntity();
        MovieKB.putResource(action, name, "action");
        comedy = genre.addEntity();
        MovieKB.putResource(comedy, name, "comedy");
        family = genre.addEntity();
        MovieKB.putResource(family, name, "family");
        musical = genre.addEntity();
        MovieKB.putResource(musical, name, "musical");
        fantasy = genre.addEntity();
        MovieKB.putResource(fantasy, name, "fantasy");
        donVitoCorleone = character.addEntity();
        MovieKB.putResource(donVitoCorleone, name, "Don Vito Corleone");
        michaelCorleone = character.addEntity();
        MovieKB.putResource(michaelCorleone, name, "Michael Corleone");
        colonelWalterEKurtz = character.addEntity();
        MovieKB.putResource(colonelWalterEKurtz, name, "Colonel Walter E. Kurtz");
        benjaminLWillard = character.addEntity();
        MovieKB.putResource(benjaminLWillard, name, "Benjamin L. Willard");
        ltVincentHanna = character.addEntity();
        MovieKB.putResource(ltVincentHanna, name, "Lt Vincent Hanna");
        neilMcCauley = character.addEntity();
        MovieKB.putResource(neilMcCauley, name, "Neil McCauley");
        bradleyFine = character.addEntity();
        MovieKB.putResource(bradleyFine, name, "Bradley Fine");
        nancyBArtingstall = character.addEntity();
        MovieKB.putResource(nancyBArtingstall, name, "Nancy B Artingstall");
        winifred = character.addEntity();
        MovieKB.putResource(winifred, name, "Winifred");
        sarah = character.addEntity();
        MovieKB.putResource(sarah, name, "Sarah");
        harry = character.addEntity();
        MovieKB.putResource(harry, name, "Harry");
        cluster0 = cluster.addEntity();
        cluster1 = cluster.addEntity();
        MovieKB.putResource(cluster0, name, "0");
        MovieKB.putResource(cluster1, name, "1");
    }

    @Override
    protected void buildRelations(GraknTx tx) {
        directedBy.addRelationship().addRolePlayer(productionBeingDirected, chineseCoffee).addRolePlayer(director, alPacino);
        MovieKB.hasCast(godfather, marlonBrando, donVitoCorleone);
        MovieKB.hasCast(godfather, alPacino, michaelCorleone);
        MovieKB.hasCast(theMuppets, missPiggy, missPiggy);
        MovieKB.hasCast(theMuppets, kermitTheFrog, kermitTheFrog);
        MovieKB.hasCast(apocalypseNow, marlonBrando, colonelWalterEKurtz);
        MovieKB.hasCast(apocalypseNow, martinSheen, benjaminLWillard);
        MovieKB.hasCast(heat, alPacino, ltVincentHanna);
        MovieKB.hasCast(heat, robertDeNiro, neilMcCauley);
        MovieKB.hasCast(spy, judeLaw, bradleyFine);
        MovieKB.hasCast(spy, mirandaHeart, nancyBArtingstall);
        MovieKB.hasCast(hocusPocus, betteMidler, winifred);
        MovieKB.hasCast(hocusPocus, sarahJessicaParker, sarah);
        MovieKB.hasCast(chineseCoffee, alPacino, harry);
        MovieKB.hasGenre(godfather, crime);
        MovieKB.hasGenre(godfather, drama);
        MovieKB.hasGenre(apocalypseNow, drama);
        MovieKB.hasGenre(apocalypseNow, war);
        MovieKB.hasGenre(heat, crime);
        MovieKB.hasGenre(heat, drama);
        MovieKB.hasGenre(heat, action);
        MovieKB.hasGenre(theMuppets, comedy);
        MovieKB.hasGenre(theMuppets, family);
        MovieKB.hasGenre(theMuppets, musical);
        MovieKB.hasGenre(hocusPocus, comedy);
        MovieKB.hasGenre(hocusPocus, family);
        MovieKB.hasGenre(hocusPocus, fantasy);
        MovieKB.hasGenre(spy, comedy);
        MovieKB.hasGenre(spy, family);
        MovieKB.hasGenre(spy, musical);
        MovieKB.hasGenre(chineseCoffee, drama);
        MovieKB.hasCluster(cluster0, godfather, apocalypseNow, heat);
        MovieKB.hasCluster(cluster1, theMuppets, hocusPocus);
    }

    @Override
    protected void buildRules(GraknTx tx) {
        Pattern when = tx.graql().parsePattern("$x has name 'expectation-when'");
        Pattern then = tx.graql().parsePattern("$x has name 'expectation-then'");
        tx.putRule("expectation-rule", when, then);
        when = tx.graql().parsePattern("$x has name 'materialize-when'");
        then = tx.graql().parsePattern("$x has name 'materialize-then'");
        tx.putRule("materialize-rule", when, then);
    }

    private static void hasCast(Thing movie, Thing person, Thing character) {
        hasCast.addRelationship().addRolePlayer(productionWithCast, movie).addRolePlayer(actor, person).addRolePlayer(characterBeingPlayed, character);
    }

    private static void hasGenre(Thing movie, Thing genre) {
        hasGenre.addRelationship().addRolePlayer(productionWithGenre, movie).addRolePlayer(genreOfProduction, genre);
    }

    private static void hasCluster(Thing cluster, Thing ... movies) {
        Relationship relationship = hasCluster.addRelationship().addRolePlayer(clusterOfProduction, cluster);
        for (Thing movie : movies) {
            relationship.addRolePlayer(productionWithCluster, movie);
        }
    }
}

