/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class NguyenKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "nguyen-test.gql";
    private final int n;

    public NguyenKB(int n) {
        this.n = n;
    }

    public static Consumer<GraknTx> get(int n) {
        return new NguyenKB(n).build();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBContext.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n) {
        int i;
        Role Rfrom = graph.getRole("R-rA");
        Role Rto = graph.getRole("R-rB");
        Role qfrom = graph.getRole("Q-rA");
        Role qto = graph.getRole("Q-rB");
        Role Pfrom = graph.getRole("P-rA");
        Role Pto = graph.getRole("P-rB");
        EntityType entity = graph.getEntityType("entity2");
        EntityType aEntity = graph.getEntityType("a-entity");
        EntityType bEntity = graph.getEntityType("b-entity");
        RelationshipType r = graph.getRelationshipType("R");
        RelationshipType p = graph.getRelationshipType("P");
        RelationshipType q = graph.getRelationshipType("Q");
        ConceptId cId = NguyenKB.putEntity(graph, "c", entity, key).getId();
        ConceptId dId = NguyenKB.putEntity(graph, "d", entity, key).getId();
        ConceptId eId = NguyenKB.putEntity(graph, "e", entity, key).getId();
        ConceptId[] aInstancesIds = new ConceptId[n + 2];
        ConceptId[] bInstancesIds = new ConceptId[n + 2];
        aInstancesIds[n + 1] = NguyenKB.putEntity(graph, "a" + (n + 1), aEntity, key).getId();
        for (i = 0; i <= n; ++i) {
            aInstancesIds[i] = NguyenKB.putEntity(graph, "a" + i, aEntity, key).getId();
            bInstancesIds[i] = NguyenKB.putEntity(graph, "b" + i, bEntity, key).getId();
        }
        p.addRelationship().addRolePlayer(Pfrom, (Thing)graph.getConcept(cId)).addRolePlayer(Pto, (Thing)graph.getConcept(dId));
        r.addRelationship().addRolePlayer(Rfrom, (Thing)graph.getConcept(dId)).addRolePlayer(Rto, (Thing)graph.getConcept(eId));
        q.addRelationship().addRolePlayer(qfrom, (Thing)graph.getConcept(eId)).addRolePlayer(qto, (Thing)graph.getConcept(aInstancesIds[0]));
        for (i = 0; i <= n; ++i) {
            p.addRelationship().addRolePlayer(Pfrom, (Thing)graph.getConcept(bInstancesIds[i])).addRolePlayer(Pto, (Thing)graph.getConcept(cId));
            p.addRelationship().addRolePlayer(Pfrom, (Thing)graph.getConcept(cId)).addRolePlayer(Pto, (Thing)graph.getConcept(bInstancesIds[i]));
            q.addRelationship().addRolePlayer(qfrom, (Thing)graph.getConcept(aInstancesIds[i])).addRolePlayer(qto, (Thing)graph.getConcept(bInstancesIds[i]));
            q.addRelationship().addRolePlayer(qfrom, (Thing)graph.getConcept(bInstancesIds[i])).addRolePlayer(qto, (Thing)graph.getConcept(aInstancesIds[i + 1]));
        }
    }
}

