/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class PathKBII
extends TestKB {
    private static final Label key = Label.of((String)"index");
    static final String gqlFile = "path-test.gql";
    private final int n;
    private final int m;

    public PathKBII(int n, int m) {
        this.m = m;
        this.n = n;
    }

    public static Consumer<GraknTx> get(int n, int m) {
        return new PathKBII(n, m).build();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBContext.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n, this.m);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n, int m) {
        int j;
        int i;
        long startTime = System.currentTimeMillis();
        EntityType vertex = graph.getEntityType("vertex");
        EntityType startVertex = graph.getEntityType("start-vertex");
        Role arcFrom = graph.getRole("arc-from");
        Role arcTo = graph.getRole("arc-to");
        RelationshipType arc = graph.getRelationshipType("arc");
        PathKBII.putEntity(graph, "a0", startVertex, key);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                PathKBII.putEntity(graph, "a" + i + "," + j, vertex, key);
            }
        }
        arc.addRelationship().addRolePlayer(arcFrom, PathKBII.getInstance(graph, "a0")).addRolePlayer(arcTo, PathKBII.getInstance(graph, "a0,0"));
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                if (j < n - 1) {
                    arc.addRelationship().addRolePlayer(arcFrom, PathKBII.getInstance(graph, "a" + i + "," + j)).addRolePlayer(arcTo, PathKBII.getInstance(graph, "a" + i + "," + (j + 1)));
                }
                if (i >= m - 1) continue;
                arc.addRelationship().addRolePlayer(arcFrom, PathKBII.getInstance(graph, "a" + i + "," + j)).addRolePlayer(arcTo, PathKBII.getInstance(graph, "a" + (i + 1) + "," + j));
            }
        }
        long loadTime = System.currentTimeMillis() - startTime;
        System.out.println("PathKBII loading time: " + loadTime + " ms");
    }
}

