/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class TransitivityChainKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "simple-transitivity.gql";
    private final int n;

    public TransitivityChainKB(int n) {
        this.n = n;
    }

    public static Consumer<GraknTx> get(int n) {
        return new TransitivityChainKB(n).build();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBContext.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n) {
        int i;
        Role qfrom = graph.getRole("Q-from");
        Role qto = graph.getRole("Q-to");
        EntityType aEntity = graph.getEntityType("a-entity");
        RelationshipType q = graph.getRelationshipType("Q");
        Thing aInst = TransitivityChainKB.putEntity(graph, "a", graph.getEntityType("entity2"), key);
        ConceptId[] aInstanceIds = new ConceptId[n];
        for (i = 0; i < n; ++i) {
            aInstanceIds[i] = TransitivityChainKB.putEntity(graph, "a" + i, aEntity, key).getId();
        }
        q.addRelationship().addRolePlayer(qfrom, aInst).addRolePlayer(qto, (Thing)graph.getConcept(aInstanceIds[0]));
        for (i = 0; i < n - 1; ++i) {
            q.addRelationship().addRolePlayer(qfrom, (Thing)graph.getConcept(aInstanceIds[i])).addRolePlayer(qto, (Thing)graph.getConcept(aInstanceIds[i + 1]));
        }
    }
}

