/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class TransitivityMatrixKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "simple-transitivity.gql";
    private final int n;
    private final int m;

    public TransitivityMatrixKB(int n, int m) {
        this.m = m;
        this.n = n;
    }

    public static Consumer<GraknTx> get(int n, int m) {
        return new TransitivityMatrixKB(n, m).build();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBContext.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n, this.m);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n, int m) {
        int j;
        int i;
        Role qfrom = graph.getRole("Q-from");
        Role qto = graph.getRole("Q-to");
        EntityType aEntity = graph.getEntityType("a-entity");
        RelationshipType q = graph.getRelationshipType("Q");
        Thing aInst = TransitivityMatrixKB.putEntity(graph, "a", graph.getEntityType("entity2"), key);
        ConceptId[][] aInstanceIds = new ConceptId[n][m];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                aInstanceIds[i][j] = TransitivityMatrixKB.putEntity(graph, "a" + i + "," + j, aEntity, key).getId();
            }
        }
        q.addRelationship().addRolePlayer(qfrom, aInst).addRolePlayer(qto, (Thing)graph.getConcept(aInstanceIds[0][0]));
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                if (i < n - 1) {
                    q.addRelationship().addRolePlayer(qfrom, (Thing)graph.getConcept(aInstanceIds[i][j])).addRolePlayer(qto, (Thing)graph.getConcept(aInstanceIds[i + 1][j]));
                }
                if (j >= m - 1) continue;
                q.addRelationship().addRolePlayer(qfrom, (Thing)graph.getConcept(aInstanceIds[i][j])).addRolePlayer(qto, (Thing)graph.getConcept(aInstanceIds[i][j + 1]));
            }
        }
    }
}

