/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.thrift.transport.TTransportException;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCassandra {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCassandra.class);
    private static AtomicBoolean CASSANDRA_RUNNING = new AtomicBoolean(false);

    public static void start() {
        if (CASSANDRA_RUNNING.compareAndSet(false, true)) {
            try {
                LOG.info("starting cassandra...");
                EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)"cassandra-embedded.yaml", (long)30000L);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    LOG.info("Thread sleep interrupted.");
                }
                LOG.info("cassandra started.");
            }
            catch (IOException | TTransportException e) {
                throw new RuntimeException("Cannot start Embedded Cassandra", e);
            }
            catch (ConfigurationException e) {
                LOG.error("Cassandra already running! Attempting to continue.");
            }
        }
    }
}

