/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisServer;
import redis.embedded.exceptions.EmbeddedRedisException;

public class EmbeddedRedis {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedRedis.class);
    private static volatile RedisServer redisServer;

    public static void start(int port, boolean force) {
        block6: {
            try {
                LOG.info("Starting redis...");
                redisServer = RedisServer.builder().port(Integer.valueOf(port)).setting("timeout 360").build();
                if (force || !redisServer.isActive()) {
                    try {
                        redisServer.start();
                    }
                    catch (EmbeddedRedisException e) {
                        LOG.warn("Unexpected Redis instance already running on port {}", (Object)port);
                    }
                    catch (Exception e) {
                        LOG.warn("Exception while trying to start Redis on port {}. Will attempt to continue.", (Object)port, (Object)e);
                    }
                    LOG.info("Redis started on {}", (Object)port);
                    break block6;
                }
                LOG.warn("Redis already running.");
            }
            catch (Exception e) {
                LOG.warn("Failure to start redis on port {}, maybe running alredy", (Object)port, (Object)e);
            }
        }
    }

    public static void start(int port) {
        EmbeddedRedis.start(port, false);
    }

    public static void forceStart(int port) {
        EmbeddedRedis.start(port, true);
    }

    public static void stop() {
        try {
            LOG.info("Stopping Redis...");
            redisServer.stop();
            LOG.info("Redis stopped.");
        }
        catch (Exception e) {
            LOG.warn("Failure while stopping redis", (Throwable)e);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (redisServer != null && redisServer.isActive()) {
                LOG.warn("Redis still running, stopping it on shutdown hook");
                redisServer.stop();
            }
        }));
    }
}

