/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractGenerator<T>
extends Generator<T> {
    SourceOfRandomness random;
    GenerationStatus status;

    AbstractGenerator(Class<T> type) {
        super(type);
    }

    public T generate(SourceOfRandomness random, GenerationStatus status) {
        this.random = random;
        this.status = status;
        return this.generate();
    }

    protected abstract T generate();

    final <S> S gen(Class<S> clazz) {
        return (S)this.gen().type(clazz).generate(this.random, this.status);
    }

    protected <S> Set<S> setOf(Class<S> clazz, int minSize, int maxSize) {
        return this.fillWith(Sets.newHashSet(), clazz, minSize, maxSize);
    }

    protected <S> List<S> listOf(Class<S> clazz, int minSize, int maxSize) {
        return this.fillWith(Lists.newArrayList(), clazz, minSize, maxSize);
    }

    private <S, U extends Collection<S>> U fillWith(U collection, Class<S> clazz, int minSize, int maxSize) {
        for (int i = 0; i < this.random.nextInt(minSize, maxSize); ++i) {
            collection.add(this.gen(clazz));
        }
        return collection;
    }
}

