/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.generator;

import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.generator.FromTxGenerator;
import ai.grakn.generator.Labels;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractSchemaConceptGenerator<T extends SchemaConcept>
extends FromTxGenerator<T> {
    private Optional<Boolean> meta = Optional.empty();

    AbstractSchemaConceptGenerator(Class<T> type) {
        super(type);
    }

    @Override
    protected final T generateFromTx() {
        Collection schemaConcepts;
        if (!this.includeNonMeta()) {
            schemaConcepts = Sets.newHashSet(this.otherMetaSchemaConcepts());
            schemaConcepts.add(this.metaSchemaConcept());
        } else {
            schemaConcepts = this.metaSchemaConcept().subs().collect(Collectors.toSet());
        }
        schemaConcepts = schemaConcepts.stream().filter(this::filter).collect(Collectors.toSet());
        if (!this.includeMeta()) {
            schemaConcepts.remove(this.metaSchemaConcept());
            schemaConcepts.removeAll(this.otherMetaSchemaConcepts());
        }
        if (schemaConcepts.isEmpty() && this.includeNonMeta()) {
            Label label = (Label)this.genFromTx(Labels.class).mustBeUnused().generate(this.random, this.status);
            assert (this.tx().getSchemaConcept(label) == null);
            return this.newSchemaConcept(label);
        }
        return (T)((SchemaConcept)this.random.choose(schemaConcepts));
    }

    protected abstract T newSchemaConcept(Label var1);

    protected abstract T metaSchemaConcept();

    protected Collection<T> otherMetaSchemaConcepts() {
        return ImmutableSet.of();
    }

    protected boolean filter(T schemaConcept) {
        return true;
    }

    private final boolean includeMeta() {
        return this.meta.orElse(true);
    }

    private final boolean includeNonMeta() {
        return this.meta.orElse(false) == false;
    }

    final AbstractSchemaConceptGenerator<T> excludeMeta() {
        this.meta = Optional.of(false);
        return this;
    }

    public final void configure(Meta meta) {
        Preconditions.checkArgument((!this.meta.isPresent() || this.meta.get() != false ? 1 : 0) != 0, (Object)"Cannot specify parameter is both meta and non-meta");
        this.meta = Optional.of(true);
    }

    public final void configure(NonMeta nonMeta) {
        Preconditions.checkArgument((!this.meta.isPresent() || this.meta.get() == false ? 1 : 0) != 0, (Object)"Cannot specify parameter is both meta and non-meta");
        this.meta = Optional.of(false);
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface NonMeta {
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface Meta {
    }
}

