/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.generator;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.generator.AbstractSchemaConceptGenerator;
import ai.grakn.generator.AbstractTypeGenerator;
import ai.grakn.generator.FromTxGenerator;
import ai.grakn.generator.Labels;
import ai.grakn.generator.ResourceValues;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.stream.Collectors;

public abstract class AbstractThingGenerator<T extends Thing, S extends Type>
extends FromTxGenerator<T> {
    private boolean withResource = false;
    private final Class<? extends AbstractTypeGenerator<S>> generatorClass;

    AbstractThingGenerator(Class<T> type, Class<? extends AbstractTypeGenerator<S>> generatorClass) {
        super(type);
        this.generatorClass = generatorClass;
    }

    @Override
    protected final T generateFromTx() {
        Type type = (Type)this.genFromTx(this.generatorClass).makeExcludeAbstractTypes().excludeMeta().generate(this.random, this.status);
        Collection instances = type.instances().collect(Collectors.toSet());
        Object thing = instances.isEmpty() ? this.newInstance(type) : (Thing)this.random.choose(instances);
        if (this.withResource && !thing.attributes(new AttributeType[0]).findAny().isPresent()) {
            AttributeType.DataType dataType = this.gen(AttributeType.DataType.class);
            Label label = (Label)this.genFromTx(Labels.class).mustBeUnused().generate(this.random, this.status);
            AttributeType attributeType = this.tx().putAttributeType(label, dataType);
            Attribute attribute = this.newResource(attributeType);
            type.attribute(attributeType);
            thing.attribute(attribute);
        }
        return thing;
    }

    protected Attribute newResource(AttributeType type) {
        AttributeType.DataType dataType = type.getDataType();
        Object value = ((ResourceValues)this.gen().make(ResourceValues.class, new Generator[0])).dataType(dataType).generate(this.random, this.status);
        return type.putAttribute(value);
    }

    public final void configure(AbstractSchemaConceptGenerator.NonMeta nonMeta) {
    }

    public final void configure(WithResource withResource) {
        this.withResource = true;
    }

    protected abstract T newInstance(S var1);

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface WithResource {
    }
}

