/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Thing;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.test.rule.SampleKBContext;
import ai.grakn.util.SampleKBLoader;

public class AdmissionsKB
extends TestKB {
    private static AttributeType<String> key;
    private static EntityType applicant;
    private static AttributeType<Long> TOEFL;
    private static AttributeType<Double> GPR;
    private static AttributeType<Long> GRE;
    private static AttributeType<Long> vGRE;
    private static AttributeType<String> specialHonours;
    private static AttributeType<String> degreeOrigin;
    private static AttributeType<String> transcript;
    private static AttributeType<String> priorGraduateWork;
    private static AttributeType<String> languageRequirement;
    private static AttributeType<String> considerGPR;
    private static AttributeType<String> admissionStatus;
    private static AttributeType<String> decisionType;

    public static SampleKBContext context() {
        return new AdmissionsKB().makeContext();
    }

    @Override
    protected void buildSchema(GraknTx tx) {
        key = tx.putAttributeType("name", AttributeType.DataType.STRING);
        TOEFL = tx.putAttributeType("TOEFL", AttributeType.DataType.LONG);
        GRE = tx.putAttributeType("GRE", AttributeType.DataType.LONG);
        vGRE = tx.putAttributeType("vGRE", AttributeType.DataType.LONG);
        GPR = tx.putAttributeType("GPR", AttributeType.DataType.DOUBLE);
        specialHonours = tx.putAttributeType("specialHonours", AttributeType.DataType.STRING);
        considerGPR = tx.putAttributeType("considerGPR", AttributeType.DataType.STRING);
        transcript = tx.putAttributeType("transcript", AttributeType.DataType.STRING);
        priorGraduateWork = tx.putAttributeType("priorGraduateWork", AttributeType.DataType.STRING);
        languageRequirement = tx.putAttributeType("languageRequirement", AttributeType.DataType.STRING);
        degreeOrigin = tx.putAttributeType("degreeOrigin", AttributeType.DataType.STRING);
        admissionStatus = tx.putAttributeType("admissionStatus", AttributeType.DataType.STRING);
        decisionType = tx.putAttributeType("decisionType", AttributeType.DataType.STRING);
        applicant = tx.putEntityType("applicant");
        applicant.attribute(TOEFL);
        applicant.attribute(GRE);
        applicant.attribute(vGRE);
        applicant.attribute(GPR);
        applicant.attribute(specialHonours);
        applicant.attribute(considerGPR);
        applicant.attribute(transcript);
        applicant.attribute(priorGraduateWork);
        applicant.attribute(languageRequirement);
        applicant.attribute(degreeOrigin);
        applicant.attribute(admissionStatus);
        applicant.attribute(decisionType);
        applicant.attribute(key);
    }

    @Override
    protected void buildInstances(GraknTx tx) {
        Thing Alice = AdmissionsKB.putEntityWithResource(tx, "Alice", applicant, key.getLabel());
        Thing Bob = AdmissionsKB.putEntityWithResource(tx, "Bob", applicant, key.getLabel());
        Thing Charlie = AdmissionsKB.putEntityWithResource(tx, "Charlie", applicant, key.getLabel());
        Thing Denis = AdmissionsKB.putEntityWithResource(tx, "Denis", applicant, key.getLabel());
        Thing Eva = AdmissionsKB.putEntityWithResource(tx, "Eva", applicant, key.getLabel());
        Thing Frank = AdmissionsKB.putEntityWithResource(tx, "Frank", applicant, key.getLabel());
        AdmissionsKB.putResource(Alice, TOEFL, 470L);
        AdmissionsKB.putResource(Alice, degreeOrigin, "nonUS");
        AdmissionsKB.putResource(Bob, priorGraduateWork, "none");
        AdmissionsKB.putResource(Bob, TOEFL, 520L);
        AdmissionsKB.putResource(Bob, degreeOrigin, "US");
        AdmissionsKB.putResource(Bob, transcript, "unavailable");
        AdmissionsKB.putResource(Bob, specialHonours, "none");
        AdmissionsKB.putResource(Bob, GRE, 1100L);
        AdmissionsKB.putResource(Charlie, priorGraduateWork, "none");
        AdmissionsKB.putResource(Charlie, TOEFL, 600L);
        AdmissionsKB.putResource(Charlie, degreeOrigin, "US");
        AdmissionsKB.putResource(Charlie, transcript, "available");
        AdmissionsKB.putResource(Charlie, specialHonours, "none");
        AdmissionsKB.putResource(Charlie, GRE, 1100L);
        AdmissionsKB.putResource(Charlie, vGRE, 400L);
        AdmissionsKB.putResource(Charlie, GPR, 2.99);
        AdmissionsKB.putResource(Denis, priorGraduateWork, "none");
        AdmissionsKB.putResource(Denis, degreeOrigin, "US");
        AdmissionsKB.putResource(Denis, transcript, "available");
        AdmissionsKB.putResource(Denis, specialHonours, "none");
        AdmissionsKB.putResource(Denis, GRE, 900L);
        AdmissionsKB.putResource(Denis, vGRE, 350L);
        AdmissionsKB.putResource(Denis, GPR, 2.5);
        AdmissionsKB.putResource(Eva, priorGraduateWork, "completed");
        AdmissionsKB.putResource(Eva, specialHonours, "valedictorian");
        AdmissionsKB.putResource(Eva, GPR, 3.0);
        AdmissionsKB.putResource(Frank, TOEFL, 550L);
        AdmissionsKB.putResource(Frank, degreeOrigin, "US");
        AdmissionsKB.putResource(Frank, transcript, "unavailable");
        AdmissionsKB.putResource(Frank, specialHonours, "none");
        AdmissionsKB.putResource(Frank, GRE, 100L);
    }

    @Override
    protected void buildRelations() {
    }

    @Override
    protected void buildRules(GraknTx tx) {
        SampleKBLoader.loadFromFile(tx, "admission-rules.gql");
    }
}

