/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.graql.Pattern;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.test.rule.SampleKBContext;

public class GeoKB
extends TestKB {
    private static AttributeType<String> key;
    private static EntityType university;
    private static EntityType city;
    private static EntityType region;
    private static EntityType country;
    private static EntityType continent;
    private static EntityType geographicalObject;
    private static RelationshipType isLocatedIn;
    private static Role geoEntity;
    private static Role entityLocation;
    private static Thing Europe;
    private static Thing Warsaw;
    private static Thing Wroclaw;
    private static Thing London;
    private static Thing Munich;
    private static Thing Paris;
    private static Thing Milan;
    private static Thing Masovia;
    private static Thing Silesia;
    private static Thing GreaterLondon;
    private static Thing Bavaria;
    private static Thing IleDeFrance;
    private static Thing Lombardy;
    private static Thing Poland;
    private static Thing England;
    private static Thing Germany;
    private static Thing France;
    private static Thing Italy;
    private static Thing UW;
    private static Thing PW;
    private static Thing Imperial;
    private static Thing UCL;

    public static SampleKBContext context() {
        return new GeoKB().makeContext();
    }

    @Override
    public void buildSchema(GraknTx tx) {
        key = tx.putAttributeType("name", AttributeType.DataType.STRING);
        geoEntity = tx.putRole("geo-entity");
        entityLocation = tx.putRole("entity-location");
        isLocatedIn = tx.putRelationshipType("is-located-in").relates(geoEntity).relates(entityLocation);
        geographicalObject = tx.putEntityType("geoObject").plays(geoEntity).plays(entityLocation);
        geographicalObject.attribute(key);
        continent = tx.putEntityType("continent").sup(geographicalObject).plays(entityLocation);
        country = tx.putEntityType("country").sup(geographicalObject).plays(geoEntity).plays(entityLocation);
        region = tx.putEntityType("region").sup(geographicalObject).plays(geoEntity).plays(entityLocation);
        city = tx.putEntityType("city").sup(geographicalObject).plays(geoEntity).plays(entityLocation);
        university = tx.putEntityType("university").plays(geoEntity);
        university.attribute(key);
    }

    @Override
    public void buildInstances(GraknTx tx) {
        Europe = GeoKB.putEntityWithResource(tx, "Europe", continent, key.getLabel());
        Poland = GeoKB.putEntityWithResource(tx, "Poland", country, key.getLabel());
        Masovia = GeoKB.putEntityWithResource(tx, "Masovia", region, key.getLabel());
        Silesia = GeoKB.putEntityWithResource(tx, "Silesia", region, key.getLabel());
        Warsaw = GeoKB.putEntityWithResource(tx, "Warsaw", city, key.getLabel());
        Wroclaw = GeoKB.putEntityWithResource(tx, "Wroclaw", city, key.getLabel());
        UW = GeoKB.putEntityWithResource(tx, "University-of-Warsaw", university, key.getLabel());
        PW = GeoKB.putEntityWithResource(tx, "Warsaw-Polytechnics", university, key.getLabel());
        England = GeoKB.putEntityWithResource(tx, "England", country, key.getLabel());
        GreaterLondon = GeoKB.putEntityWithResource(tx, "GreaterLondon", region, key.getLabel());
        London = GeoKB.putEntityWithResource(tx, "London", city, key.getLabel());
        Imperial = GeoKB.putEntityWithResource(tx, "Imperial College London", university, key.getLabel());
        UCL = GeoKB.putEntityWithResource(tx, "University College London", university, key.getLabel());
        Germany = GeoKB.putEntityWithResource(tx, "Germany", country, key.getLabel());
        Bavaria = GeoKB.putEntityWithResource(tx, "Bavaria", region, key.getLabel());
        Munich = GeoKB.putEntityWithResource(tx, "Munich", city, key.getLabel());
        GeoKB.putEntityWithResource(tx, "University of Munich", university, key.getLabel());
        France = GeoKB.putEntityWithResource(tx, "France", country, key.getLabel());
        IleDeFrance = GeoKB.putEntityWithResource(tx, "IleDeFrance", region, key.getLabel());
        Paris = GeoKB.putEntityWithResource(tx, "Paris", city, key.getLabel());
        Italy = GeoKB.putEntityWithResource(tx, "Italy", country, key.getLabel());
        Lombardy = GeoKB.putEntityWithResource(tx, "Lombardy", region, key.getLabel());
        Milan = GeoKB.putEntityWithResource(tx, "Milan", city, key.getLabel());
    }

    @Override
    public void buildRelations() {
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Poland).addRolePlayer(entityLocation, Europe);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Masovia).addRolePlayer(entityLocation, Poland);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Warsaw).addRolePlayer(entityLocation, Masovia);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, PW).addRolePlayer(entityLocation, Warsaw);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, UW).addRolePlayer(entityLocation, Warsaw);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Silesia).addRolePlayer(entityLocation, Poland);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Wroclaw).addRolePlayer(entityLocation, Silesia);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Imperial).addRolePlayer(entityLocation, London);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, UCL).addRolePlayer(entityLocation, London);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, London).addRolePlayer(entityLocation, GreaterLondon);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, GreaterLondon).addRolePlayer(entityLocation, England);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, England).addRolePlayer(entityLocation, Europe);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Munich).addRolePlayer(entityLocation, Bavaria);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Bavaria).addRolePlayer(entityLocation, Germany);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Germany).addRolePlayer(entityLocation, Europe);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Milan).addRolePlayer(entityLocation, Lombardy);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Lombardy).addRolePlayer(entityLocation, Italy);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Italy).addRolePlayer(entityLocation, Europe);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, Paris).addRolePlayer(entityLocation, IleDeFrance);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, IleDeFrance).addRolePlayer(entityLocation, France);
        isLocatedIn.addRelationship().addRolePlayer(geoEntity, France).addRolePlayer(entityLocation, Europe);
    }

    @Override
    public void buildRules(GraknTx tx) {
        Pattern transitivity_LHS = tx.graql().parser().parsePattern("{(geo-entity: $x, entity-location: $y) isa is-located-in;(geo-entity: $y, entity-location: $z) isa is-located-in;}");
        Pattern transitivity_RHS = tx.graql().parser().parsePattern("{(geo-entity: $x, entity-location: $z) isa is-located-in;}");
        tx.putRule("Geo Rule", transitivity_LHS, transitivity_RHS);
    }
}

