/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.test.rule.SampleKBContext;
import ai.grakn.util.SampleKBLoader;
import java.util.function.Consumer;

public class TailRecursionKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "tail-recursion-test.gql";
    private final int n;
    private final int m;

    public TailRecursionKB(int n, int m) {
        this.n = n;
        this.m = m;
    }

    public static SampleKBContext context(int n, int m) {
        return new TailRecursionKB(n, m).makeContext();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBLoader.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n, this.m);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n, int m) {
        Role qfrom = graph.getRole("Q-from");
        Role qto = graph.getRole("Q-to");
        EntityType aEntity = graph.getEntityType("a-entity");
        EntityType bEntity = graph.getEntityType("b-entity");
        RelationshipType q = graph.getRelationshipType("Q");
        TailRecursionKB.putEntityWithResource(graph, "a0", aEntity, key);
        for (int i = 1; i <= m + 1; ++i) {
            for (int j = 1; j <= n; ++j) {
                TailRecursionKB.putEntityWithResource(graph, "b" + i + "," + j, bEntity, key);
            }
        }
        for (int j = 1; j <= n; ++j) {
            q.addRelationship().addRolePlayer(qfrom, TailRecursionKB.getInstance(graph, "a0")).addRolePlayer(qto, TailRecursionKB.getInstance(graph, "b1," + j));
            for (int i = 1; i <= m; ++i) {
                q.addRelationship().addRolePlayer(qfrom, TailRecursionKB.getInstance(graph, "b" + i + "," + j)).addRolePlayer(qto, TailRecursionKB.getInstance(graph, "b" + (i + 1) + "," + j));
            }
        }
    }
}

