/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.test.rule.SampleKBContext;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class TestKB {
    protected void buildSchema(GraknTx tx) {
    }

    protected void buildInstances(GraknTx tx) {
    }

    protected void buildRelations() {
    }

    protected void buildRules(GraknTx tx) {
    }

    public Consumer<GraknTx> build() {
        return tx -> {
            this.buildSchema((GraknTx)tx);
            this.buildInstances((GraknTx)tx);
            this.buildRelations();
            this.buildRules((GraknTx)tx);
        };
    }

    public SampleKBContext makeContext() {
        return SampleKBContext.load(this.build());
    }

    public static Thing putEntityWithResource(GraknTx tx, String id, EntityType type, Label key) {
        Entity inst = type.addEntity();
        TestKB.putResource((Thing)inst, (AttributeType)tx.getSchemaConcept(key), id);
        return inst;
    }

    public static <T> void putResource(Thing thing, AttributeType<T> attributeType, T resource) {
        Attribute attributeInstance = attributeType.putAttribute(resource);
        thing.attribute(attributeInstance);
    }

    public static Thing getInstance(GraknTx tx, String id) {
        Set things = tx.getAttributesByValue((Object)id).stream().flatMap(Attribute::ownerInstances).collect(Collectors.toSet());
        if (things.size() != 1) {
            throw new IllegalStateException("Multiple things with given resource value");
        }
        return (Thing)things.iterator().next();
    }
}

