/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.rule;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.thrift.transport.TTransportException;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCassandraContext
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCassandraContext.class);
    private static final String DEFAULT_YAML_FILE_PATH = "cassandra-embedded.yaml";
    private static AtomicBoolean CASSANDRA_RUNNING = new AtomicBoolean(false);
    private static AtomicInteger IN_CASSANDRA_CONTEXT = new AtomicInteger(0);
    private String yamlFilePath;

    private EmbeddedCassandraContext(String yamlFilePath) {
        this.yamlFilePath = yamlFilePath;
    }

    public static EmbeddedCassandraContext create() {
        return new EmbeddedCassandraContext(DEFAULT_YAML_FILE_PATH);
    }

    public static EmbeddedCassandraContext create(String yamlFilePath) {
        return new EmbeddedCassandraContext(yamlFilePath);
    }

    public static boolean inCassandraContext() {
        return IN_CASSANDRA_CONTEXT.get() > 0;
    }

    protected void before() throws Throwable {
        if (CASSANDRA_RUNNING.compareAndSet(false, true)) {
            try {
                LOG.info("starting cassandra...");
                EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)this.yamlFilePath, (long)30000L);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    LOG.info("Thread sleep interrupted.");
                }
                LOG.info("cassandra started.");
            }
            catch (IOException | TTransportException e) {
                throw new RuntimeException("Cannot start Embedded Cassandra", e);
            }
            catch (ConfigurationException e) {
                LOG.error("Cassandra already running! Attempting to continue.");
            }
        }
        IN_CASSANDRA_CONTEXT.incrementAndGet();
    }

    protected void after() {
        IN_CASSANDRA_CONTEXT.decrementAndGet();
    }
}

