/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.rule;

import ai.grakn.redismock.RedisServer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.rules.ExternalResource;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class InMemoryRedisContext
extends ExternalResource {
    private static final JedisPoolConfig DEFAULT_CONFIG = new JedisPoolConfig();
    private final Map<JedisPoolConfig, JedisPool> pools = new HashMap<JedisPoolConfig, JedisPool>();
    private final int port;
    @Nullable
    private RedisServer server = null;

    private InMemoryRedisContext(int port) {
        this.port = port;
    }

    public static InMemoryRedisContext create() {
        return InMemoryRedisContext.create(0);
    }

    public static InMemoryRedisContext create(int port) {
        return new InMemoryRedisContext(port);
    }

    protected void before() throws Throwable {
        try {
            this.server = RedisServer.newRedisServer((int)this.port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.server.start();
    }

    protected void after() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    public RedisServer server() {
        this.checkInitialised();
        assert (this.server != null);
        return this.server;
    }

    public JedisPool jedisPool() {
        return this.jedisPool(DEFAULT_CONFIG);
    }

    public JedisPool jedisPool(JedisPoolConfig config) {
        this.checkInitialised();
        assert (this.server != null);
        if (!this.pools.containsKey(config)) {
            JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, this.server.getHost(), this.server.getBindPort(), 1000000);
            this.pools.put(config, pool);
        }
        return this.pools.get(config);
    }

    private void checkInitialised() {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"InMemoryRedisContext not initialised");
    }
}

