/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.rule;

import ai.grakn.GraknTx;
import ai.grakn.test.rule.CompositeTestRule;
import ai.grakn.test.rule.SessionContext;
import ai.grakn.util.SampleKBLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;

public class SampleKBContext
extends CompositeTestRule {
    private final SampleKBLoader loader;

    private SampleKBContext(SampleKBLoader loader) {
        this.loader = loader;
    }

    public static SampleKBContext empty() {
        return SampleKBContext.getContext(null);
    }

    public static SampleKBContext load(Consumer<GraknTx> build) {
        return SampleKBContext.getContext(build);
    }

    public static SampleKBContext load(String ... files) {
        return SampleKBContext.getContext(graknGraph -> {
            for (String file : files) {
                SampleKBLoader.loadFromFile(graknGraph, file);
            }
        });
    }

    private static SampleKBContext getContext(@Nullable Consumer<GraknTx> preLoad) {
        return new SampleKBContext(SampleKBLoader.preLoad(preLoad));
    }

    @Override
    protected List<TestRule> testRules() {
        return ImmutableList.of((Object)SessionContext.create());
    }

    public GraknTx tx() {
        this.checkInContext();
        return this.loader.tx();
    }

    public void rollback() {
        this.checkInContext();
        this.loader.rollback();
    }

    private void checkInContext() {
        Preconditions.checkState((boolean)SessionContext.canUseTx(), (Object)"EmbeddedCassandraContext may not have started");
    }
}

