/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.util;

import ai.grakn.GraknSession;
import ai.grakn.GraknSystemProperty;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.GraknConfig;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.factory.GraknSessionLocal;
import ai.grakn.factory.TxFactory;
import ai.grakn.graql.Query;
import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.GraknTxTinker;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SampleKBLoader {
    private final TxFactory<?> factory;
    @Nullable
    private Consumer<GraknTx> preLoad;
    private boolean graphLoaded = false;
    private GraknTx tx;

    private SampleKBLoader(@Nullable Consumer<GraknTx> preLoad) {
        GraknSessionLocal session = GraknSessionLocal.create(SampleKBLoader.randomKeyspace(), "in-memory", GraknConfig.create());
        this.factory = FactoryBuilder.getFactory((GraknSession)session, (boolean)false);
        this.preLoad = preLoad;
    }

    public static SampleKBLoader empty() {
        return new SampleKBLoader(null);
    }

    public static SampleKBLoader preLoad(@Nullable Consumer<GraknTx> build) {
        return new SampleKBLoader(build);
    }

    public GraknTx tx() {
        if (this.tx == null || this.tx.isClosed()) {
            if (!this.graphLoaded) {
                try (GraknTxAbstract graph = this.factory.open(GraknTxType.WRITE);){
                    this.load((GraknTx)graph);
                    graph.commit();
                    this.graphLoaded = true;
                }
            }
            this.tx = this.factory.open(GraknTxType.WRITE);
        }
        return this.tx;
    }

    public void rollback() {
        if (this.tx instanceof GraknTxTinker) {
            this.tx.admin().delete();
            this.graphLoaded = false;
        } else if (!this.tx.isClosed()) {
            this.tx.close();
        }
        this.tx = this.tx();
    }

    private void load(GraknTx graph) {
        if (this.preLoad != null) {
            this.preLoad.accept(graph);
        }
    }

    public static Keyspace randomKeyspace() {
        return Keyspace.of((String)("a" + UUID.randomUUID().toString().replaceAll("-", "")));
    }

    public static void loadFromFile(GraknTx graph, String file) {
        List queries;
        File graql = new File(GraknSystemProperty.PROJECT_RELATIVE_DIR.value() + "/grakn-test-tools/src/main/graql/" + file);
        try {
            queries = Files.readLines((File)graql, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        graph.graql().parser().parseList(queries.stream().collect(Collectors.joining("\n"))).forEach(Query::execute);
    }
}

