/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.matcher;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.StringUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.stream.Stream;

public class MatchableConcept {
    static final ImmutableSet<Label> NAME_TYPES = ImmutableSet.of((Object)Label.of((String)"name"), (Object)Label.of((String)"title"));
    private final Concept concept;

    private MatchableConcept(Concept concept) {
        this.concept = concept;
    }

    public static MatchableConcept of(Concept concept) {
        return new MatchableConcept(concept);
    }

    Concept get() {
        return this.concept;
    }

    public String toString() {
        if (this.concept.isAttribute()) {
            return "hasValue(" + StringUtil.valueToString((Object)this.concept.asAttribute().value()) + ")";
        }
        if (this.concept.isThing()) {
            Thing thing = this.concept.asThing();
            Stream resources = thing.attributes(new AttributeType[0]);
            Optional<Object> value = resources.filter(resource -> NAME_TYPES.contains((Object)resource.type().label())).map(Attribute::value).findFirst();
            return "instance(" + value.map(StringUtil::valueToString).orElse("") + ") isa " + thing.type().label();
        }
        if (this.concept.isType()) {
            return "type(" + this.concept.asType().label() + ")";
        }
        if (this.concept.isRole()) {
            return "role(" + this.concept.asRole().label() + ")";
        }
        if (this.concept.isRule()) {
            return "rule(" + this.concept.asRule().label() + ")";
        }
        throw CommonUtil.unreachableStatement((String)("Unrecognised concept " + this.concept));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchableConcept that = (MatchableConcept)o;
        return this.concept.equals(that.concept);
    }

    public int hashCode() {
        return this.concept.hashCode();
    }
}

