/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.rpc;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class GrpcTestUtil {
    public static Matcher<StatusRuntimeException> hasStatus(Status status) {
        Matcher statusMatcher;
        Matcher hasCode = Matchers.hasProperty((String)"code", (Matcher)Matchers.is((Object)status.getCode()));
        String description = status.getDescription();
        if (description == null) {
            statusMatcher = hasCode;
        } else {
            Matcher hasDescription = Matchers.hasProperty((String)"description", (Matcher)Matchers.is((Object)description));
            statusMatcher = Matchers.allOf((Matcher)hasCode, (Matcher)hasDescription);
        }
        return Matchers.allOf((Matcher)Matchers.isA(StatusRuntimeException.class), (Matcher)Matchers.hasProperty((String)"status", (Matcher)statusMatcher));
    }

    public static <T> Matcher<StatusRuntimeException> hasMetadata(final Metadata.Key<T> key, final T value) {
        return new TypeSafeMatcher<StatusRuntimeException>(){

            protected boolean matchesSafely(StatusRuntimeException item) {
                return Objects.equals(item.getTrailers().get(key), value);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)String.format("has metadata %s=%s", key.name(), value));
            }
        };
    }
}

