/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.graql.Pattern;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.test.rule.SampleKBContext;

public class GeoKB
extends TestKB {
    private static AttributeType<String> key;
    private static EntityType university;
    private static EntityType city;
    private static EntityType region;
    private static EntityType country;
    private static EntityType continent;
    private static EntityType geographicalObject;
    private static RelationshipType isLocatedIn;
    private static Role geoEntity;
    private static Role entityLocation;
    private static Thing Europe;
    private static Thing Warsaw;
    private static Thing Wroclaw;
    private static Thing London;
    private static Thing Munich;
    private static Thing Paris;
    private static Thing Milan;
    private static Thing Masovia;
    private static Thing Silesia;
    private static Thing GreaterLondon;
    private static Thing Bavaria;
    private static Thing IleDeFrance;
    private static Thing Lombardy;
    private static Thing Poland;
    private static Thing England;
    private static Thing Germany;
    private static Thing France;
    private static Thing Italy;
    private static Thing UW;
    private static Thing PW;
    private static Thing Imperial;
    private static Thing UCL;

    public static SampleKBContext context() {
        return new GeoKB().makeContext();
    }

    @Override
    public void buildSchema(GraknTx tx) {
        key = tx.putAttributeType("name", AttributeType.DataType.STRING);
        geoEntity = tx.putRole("geo-entity");
        entityLocation = tx.putRole("entity-location");
        isLocatedIn = tx.putRelationshipType("is-located-in").relates(geoEntity).relates(entityLocation);
        geographicalObject = tx.putEntityType("geoObject").plays(geoEntity).plays(entityLocation);
        geographicalObject.has(key);
        continent = tx.putEntityType("continent").sup(geographicalObject).plays(entityLocation);
        country = tx.putEntityType("country").sup(geographicalObject).plays(geoEntity).plays(entityLocation);
        region = tx.putEntityType("region").sup(geographicalObject).plays(geoEntity).plays(entityLocation);
        city = tx.putEntityType("city").sup(geographicalObject).plays(geoEntity).plays(entityLocation);
        university = tx.putEntityType("university").plays(geoEntity);
        university.has(key);
    }

    @Override
    public void buildInstances(GraknTx tx) {
        Europe = GeoKB.putEntityWithResource(tx, "Europe", continent, key.label());
        Poland = GeoKB.putEntityWithResource(tx, "Poland", country, key.label());
        Masovia = GeoKB.putEntityWithResource(tx, "Masovia", region, key.label());
        Silesia = GeoKB.putEntityWithResource(tx, "Silesia", region, key.label());
        Warsaw = GeoKB.putEntityWithResource(tx, "Warsaw", city, key.label());
        Wroclaw = GeoKB.putEntityWithResource(tx, "Wroclaw", city, key.label());
        UW = GeoKB.putEntityWithResource(tx, "University-of-Warsaw", university, key.label());
        PW = GeoKB.putEntityWithResource(tx, "Warsaw-Polytechnics", university, key.label());
        England = GeoKB.putEntityWithResource(tx, "England", country, key.label());
        GreaterLondon = GeoKB.putEntityWithResource(tx, "GreaterLondon", region, key.label());
        London = GeoKB.putEntityWithResource(tx, "London", city, key.label());
        Imperial = GeoKB.putEntityWithResource(tx, "Imperial College London", university, key.label());
        UCL = GeoKB.putEntityWithResource(tx, "University College London", university, key.label());
        Germany = GeoKB.putEntityWithResource(tx, "Germany", country, key.label());
        Bavaria = GeoKB.putEntityWithResource(tx, "Bavaria", region, key.label());
        Munich = GeoKB.putEntityWithResource(tx, "Munich", city, key.label());
        GeoKB.putEntityWithResource(tx, "University of Munich", university, key.label());
        France = GeoKB.putEntityWithResource(tx, "France", country, key.label());
        IleDeFrance = GeoKB.putEntityWithResource(tx, "IleDeFrance", region, key.label());
        Paris = GeoKB.putEntityWithResource(tx, "Paris", city, key.label());
        Italy = GeoKB.putEntityWithResource(tx, "Italy", country, key.label());
        Lombardy = GeoKB.putEntityWithResource(tx, "Lombardy", region, key.label());
        Milan = GeoKB.putEntityWithResource(tx, "Milan", city, key.label());
    }

    @Override
    public void buildRelations() {
        isLocatedIn.create().assign(geoEntity, Poland).assign(entityLocation, Europe);
        isLocatedIn.create().assign(geoEntity, Masovia).assign(entityLocation, Poland);
        isLocatedIn.create().assign(geoEntity, Warsaw).assign(entityLocation, Masovia);
        isLocatedIn.create().assign(geoEntity, PW).assign(entityLocation, Warsaw);
        isLocatedIn.create().assign(geoEntity, UW).assign(entityLocation, Warsaw);
        isLocatedIn.create().assign(geoEntity, Silesia).assign(entityLocation, Poland);
        isLocatedIn.create().assign(geoEntity, Wroclaw).assign(entityLocation, Silesia);
        isLocatedIn.create().assign(geoEntity, Imperial).assign(entityLocation, London);
        isLocatedIn.create().assign(geoEntity, UCL).assign(entityLocation, London);
        isLocatedIn.create().assign(geoEntity, London).assign(entityLocation, GreaterLondon);
        isLocatedIn.create().assign(geoEntity, GreaterLondon).assign(entityLocation, England);
        isLocatedIn.create().assign(geoEntity, England).assign(entityLocation, Europe);
        isLocatedIn.create().assign(geoEntity, Munich).assign(entityLocation, Bavaria);
        isLocatedIn.create().assign(geoEntity, Bavaria).assign(entityLocation, Germany);
        isLocatedIn.create().assign(geoEntity, Germany).assign(entityLocation, Europe);
        isLocatedIn.create().assign(geoEntity, Milan).assign(entityLocation, Lombardy);
        isLocatedIn.create().assign(geoEntity, Lombardy).assign(entityLocation, Italy);
        isLocatedIn.create().assign(geoEntity, Italy).assign(entityLocation, Europe);
        isLocatedIn.create().assign(geoEntity, Paris).assign(entityLocation, IleDeFrance);
        isLocatedIn.create().assign(geoEntity, IleDeFrance).assign(entityLocation, France);
        isLocatedIn.create().assign(geoEntity, France).assign(entityLocation, Europe);
    }

    @Override
    public void buildRules(GraknTx tx) {
        Pattern transitivity_LHS = tx.graql().parser().parsePattern("{(geo-entity: $x, entity-location: $y) isa is-located-in;(geo-entity: $y, entity-location: $z) isa is-located-in;}");
        Pattern transitivity_RHS = tx.graql().parser().parsePattern("{(geo-entity: $x, entity-location: $z) isa is-located-in;}");
        tx.putRule("Geo Rule", transitivity_LHS, transitivity_RHS);
    }
}

