/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.test.rule.SampleKBContext;
import ai.grakn.util.SampleKBLoader;
import java.util.function.Consumer;

public class LinearTransitivityMatrixKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "linearTransitivity.gql";
    private final int n;
    private final int m;

    private LinearTransitivityMatrixKB(int n, int m) {
        this.m = m;
        this.n = n;
    }

    public static SampleKBContext context(int n, int m) {
        return new LinearTransitivityMatrixKB(n, m).makeContext();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBLoader.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n, this.m);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n, int m) {
        int j;
        int i;
        Role Qfrom = graph.getRole("Q-from");
        Role Qto = graph.getRole("Q-to");
        EntityType aEntity = graph.getEntityType("a-entity");
        RelationshipType Q = graph.getRelationshipType("Q");
        ConceptId[][] aInstancesIds = new ConceptId[n + 1][m + 1];
        Thing aInst = LinearTransitivityMatrixKB.putEntityWithResource(graph, "a", graph.getEntityType("entity2"), key);
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                aInstancesIds[i][j] = LinearTransitivityMatrixKB.putEntityWithResource(graph, "a" + i + "," + j, aEntity, key).id();
            }
        }
        Q.create().assign(Qfrom, aInst).assign(Qto, (Thing)graph.getConcept(aInstancesIds[1][1]));
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                if (i < n) {
                    Q.create().assign(Qfrom, (Thing)graph.getConcept(aInstancesIds[i][j])).assign(Qto, (Thing)graph.getConcept(aInstancesIds[i + 1][j]));
                }
                if (j >= m) continue;
                Q.create().assign(Qfrom, (Thing)graph.getConcept(aInstancesIds[i][j])).assign(Qto, (Thing)graph.getConcept(aInstancesIds[i][j + 1]));
            }
        }
    }
}

