/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.test.kbs.TestKB;
import ai.grakn.test.rule.SampleKBContext;
import ai.grakn.util.SampleKBLoader;
import java.util.function.Consumer;

public class NguyenKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private static final String gqlFile = "nguyen-test.gql";
    private final int n;

    public NguyenKB(int n) {
        this.n = n;
    }

    public static SampleKBContext context(int n) {
        return new NguyenKB(n).makeContext();
    }

    @Override
    public Consumer<GraknTx> build() {
        return graph -> {
            SampleKBLoader.loadFromFile(graph, gqlFile);
            this.buildExtensionalDB((GraknTx)graph, this.n);
        };
    }

    private void buildExtensionalDB(GraknTx graph, int n) {
        int i;
        Role Rfrom = graph.getRole("R-rA");
        Role Rto = graph.getRole("R-rB");
        Role qfrom = graph.getRole("Q-rA");
        Role qto = graph.getRole("Q-rB");
        Role Pfrom = graph.getRole("P-rA");
        Role Pto = graph.getRole("P-rB");
        EntityType entity = graph.getEntityType("entity2");
        EntityType aEntity = graph.getEntityType("a-entity");
        EntityType bEntity = graph.getEntityType("b-entity");
        RelationshipType r = graph.getRelationshipType("R");
        RelationshipType p = graph.getRelationshipType("P");
        RelationshipType q = graph.getRelationshipType("Q");
        ConceptId cId = NguyenKB.putEntityWithResource(graph, "c", entity, key).id();
        ConceptId dId = NguyenKB.putEntityWithResource(graph, "d", entity, key).id();
        ConceptId eId = NguyenKB.putEntityWithResource(graph, "e", entity, key).id();
        ConceptId[] aInstancesIds = new ConceptId[n + 2];
        ConceptId[] bInstancesIds = new ConceptId[n + 2];
        aInstancesIds[n + 1] = NguyenKB.putEntityWithResource(graph, "a" + (n + 1), aEntity, key).id();
        for (i = 0; i <= n; ++i) {
            aInstancesIds[i] = NguyenKB.putEntityWithResource(graph, "a" + i, aEntity, key).id();
            bInstancesIds[i] = NguyenKB.putEntityWithResource(graph, "b" + i, bEntity, key).id();
        }
        p.create().assign(Pfrom, (Thing)graph.getConcept(cId)).assign(Pto, (Thing)graph.getConcept(dId));
        r.create().assign(Rfrom, (Thing)graph.getConcept(dId)).assign(Rto, (Thing)graph.getConcept(eId));
        q.create().assign(qfrom, (Thing)graph.getConcept(eId)).assign(qto, (Thing)graph.getConcept(aInstancesIds[0]));
        for (i = 0; i <= n; ++i) {
            p.create().assign(Pfrom, (Thing)graph.getConcept(bInstancesIds[i])).assign(Pto, (Thing)graph.getConcept(cId));
            p.create().assign(Pfrom, (Thing)graph.getConcept(cId)).assign(Pto, (Thing)graph.getConcept(bInstancesIds[i]));
            q.create().assign(qfrom, (Thing)graph.getConcept(aInstancesIds[i])).assign(qto, (Thing)graph.getConcept(bInstancesIds[i]));
            q.create().assign(qfrom, (Thing)graph.getConcept(bInstancesIds[i])).assign(qto, (Thing)graph.getConcept(aInstancesIds[i + 1]));
        }
    }
}

