/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.test.kbs.AbstractPathKB;
import ai.grakn.test.rule.SampleKBContext;

public class PathMatrixKB
extends AbstractPathKB {
    private PathMatrixKB(int n, int m) {
        super("path-test.gql", Label.of((String)"index"), n, m);
    }

    public static SampleKBContext context(int n, int m) {
        return new PathMatrixKB(n, m).makeContext();
    }

    @Override
    protected void buildExtensionalDB(GraknTx graph, int n, int m) {
        int j;
        int i;
        long startTime = System.currentTimeMillis();
        EntityType vertex = graph.getEntityType("vertex");
        EntityType startVertex = graph.getEntityType("start-vertex");
        Role arcFrom = graph.getRole("arc-from");
        Role arcTo = graph.getRole("arc-to");
        RelationshipType arc = graph.getRelationshipType("arc");
        PathMatrixKB.putEntityWithResource(graph, "a0", startVertex, this.getKey());
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                PathMatrixKB.putEntityWithResource(graph, "a" + i + "," + j, vertex, this.getKey());
            }
        }
        arc.create().assign(arcFrom, PathMatrixKB.getInstance(graph, "a0")).assign(arcTo, PathMatrixKB.getInstance(graph, "a0,0"));
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                if (j < n - 1) {
                    arc.create().assign(arcFrom, PathMatrixKB.getInstance(graph, "a" + i + "," + j)).assign(arcTo, PathMatrixKB.getInstance(graph, "a" + i + "," + (j + 1)));
                }
                if (i >= m - 1) continue;
                arc.create().assign(arcFrom, PathMatrixKB.getInstance(graph, "a" + i + "," + j)).assign(arcTo, PathMatrixKB.getInstance(graph, "a" + (i + 1) + "," + j));
            }
        }
        long loadTime = System.currentTimeMillis() - startTime;
        System.out.println("PathKBII loading time: " + loadTime + " ms");
    }
}

