/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.test.kbs.AbstractPathKB;
import ai.grakn.test.rule.SampleKBContext;
import com.google.common.math.IntMath;

public class PathTreeKB
extends AbstractPathKB {
    private PathTreeKB(int n, int m) {
        super("path-test.gql", Label.of((String)"index"), n, m);
    }

    PathTreeKB(String gqlFile, Label label, int n, int m) {
        super(gqlFile, label, n, m);
    }

    public static SampleKBContext context(int n, int children) {
        return new PathTreeKB(n, children).makeContext();
    }

    @Override
    protected void buildExtensionalDB(GraknTx tx, int n, int children) {
        this.buildTree(tx, tx.getRole("arc-from"), tx.getRole("arc-to"), n, children);
    }

    void buildTree(GraknTx tx, Role fromRole, Role toRole, int n, int children) {
        int j;
        int m;
        int i;
        long startTime = System.currentTimeMillis();
        EntityType vertex = tx.getEntityType("vertex");
        EntityType startVertex = tx.getEntityType("start-vertex");
        RelationshipType arc = tx.getRelationshipType("arc");
        PathTreeKB.putEntityWithResource(tx, "a0", startVertex, this.getKey());
        int outputThreshold = 500;
        for (i = 1; i <= n; ++i) {
            m = IntMath.pow((int)children, (int)i);
            for (j = 0; j < m; ++j) {
                PathTreeKB.putEntityWithResource(tx, "a" + i + "," + j, vertex, this.getKey());
                if (j == 0 || j % outputThreshold != 0) continue;
                System.out.println(j + " entities out of " + m + " inserted");
            }
        }
        for (int j2 = 0; j2 < children; ++j2) {
            arc.create().assign(fromRole, PathTreeKB.getInstance(tx, "a0")).assign(toRole, PathTreeKB.getInstance(tx, "a1," + j2));
        }
        for (i = 1; i < n; ++i) {
            m = IntMath.pow((int)children, (int)i);
            for (j = 0; j < m; ++j) {
                for (int c = 0; c < children; ++c) {
                    arc.create().assign(fromRole, PathTreeKB.getInstance(tx, "a" + i + "," + j)).assign(toRole, PathTreeKB.getInstance(tx, "a" + (i + 1) + "," + (j * children + c)));
                }
                if (j == 0 || j % outputThreshold != 0) continue;
                System.out.println("level " + i + "/" + (n - 1) + ": " + j + " entities out of " + m + " connected");
            }
        }
        long loadTime = System.currentTimeMillis() - startTime;
        System.out.println("PathKB loading time: " + loadTime + " ms");
    }
}

