/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test;

import ai.grakn.client.Client;
import ai.grakn.engine.GraknEngineConfig;
import ai.grakn.engine.tasks.TaskManager;
import ai.grakn.engine.tasks.manager.StandaloneTaskManager;
import ai.grakn.engine.tasks.manager.singlequeue.SingleQueueTaskManager;
import ai.grakn.test.GraknTestEnv;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.junit.rules.ExternalResource;

public class DistributionContext
extends ExternalResource {
    private static final String LOG_LEVEL = "INFO";
    private static final FilenameFilter jarFiles = (dir, name) -> name.toLowerCase().endsWith(".jar");
    private static final String ZIP = "grakn-dist-0.13.0.zip";
    private static final String CURRENT_DIRECTORY = System.getProperty("user.dir");
    private static final String TARGET_DIRECTORY = CURRENT_DIRECTORY + "/../grakn-dist/target/";
    private static final String DIST_DIRECTORY = TARGET_DIRECTORY + "grakn-dist-" + "0.13.0";
    private static final Set<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE});
    private final Class<? extends TaskManager> taskManagerClass;
    private Process engineProcess;
    private int port = 4567;
    private boolean inheritIO = true;

    private DistributionContext(Class<? extends TaskManager> taskManagerClass) {
        this.taskManagerClass = taskManagerClass;
    }

    public static DistributionContext startSingleQueueEngineProcess() {
        return new DistributionContext(SingleQueueTaskManager.class);
    }

    public static DistributionContext startInMemoryEngineProcess() {
        return new DistributionContext(StandaloneTaskManager.class);
    }

    public DistributionContext port(int port) {
        this.port = port;
        return this;
    }

    public DistributionContext inheritIO(boolean inheritIO) {
        this.inheritIO = inheritIO;
        return this;
    }

    public boolean restart() throws IOException {
        boolean isStarted;
        boolean bl = isStarted = this.engineProcess != null && this.engineProcess.isAlive();
        if (!isStarted) {
            return false;
        }
        this.engineProcess.destroyForcibly();
        this.engineProcess = this.newEngineProcess(this.port);
        DistributionContext.waitForEngine(this.port);
        return true;
    }

    public int port() {
        return this.port;
    }

    public void before() throws Throwable {
        this.unzipDistribution();
        GraknTestEnv.ensureCassandraRunning();
        GraknTestEnv.startKafka();
        this.engineProcess = this.newEngineProcess(this.port);
        DistributionContext.waitForEngine(this.port);
    }

    public void after() {
        this.engineProcess.destroyForcibly();
        try {
            GraknTestEnv.stopKafka();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not shut down", e);
        }
    }

    private void unzipDistribution() throws ZipException, IOException {
        ZipFile zipped = new ZipFile(TARGET_DIRECTORY + ZIP);
        zipped.extractAll(TARGET_DIRECTORY);
        Files.setPosixFilePermissions(new File(DIST_DIRECTORY + "/bin/grakn-engine.sh").toPath(), permissions);
    }

    private Process newEngineProcess(Integer port) throws IOException {
        Properties properties = GraknEngineConfig.getInstance().getProperties();
        properties.setProperty("log.level", LOG_LEVEL);
        properties.setProperty("server.port", port.toString());
        properties.setProperty("taskmanager.implementation", this.taskManagerClass.getName());
        File propertiesFile = new File("grakn-engine-" + port + ".properties");
        propertiesFile.deleteOnExit();
        try (FileOutputStream os = new FileOutputStream(propertiesFile);){
            properties.store(os, null);
        }
        String[] commands = new String[]{"java", "-cp", this.getClassPath(), "-Dgrakn.dir=" + DIST_DIRECTORY + "/bin", "-Dgrakn.conf=" + propertiesFile.getAbsolutePath(), "ai.grakn.engine.GraknEngineServer", "&"};
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        if (this.inheritIO) {
            processBuilder.inheritIO();
        }
        return processBuilder.start();
    }

    private String getClassPath() {
        return Stream.of(new File(DIST_DIRECTORY + "/lib").listFiles(jarFiles)).filter(f -> !f.getName().contains("slf4j-log4j12")).map(File::getAbsolutePath).collect(Collectors.joining(":"));
    }

    private static void waitForEngine(int port) {
        long endTime = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < endTime) {
            if (Client.serverIsRunning((String)("localhost:" + port))) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

