/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test;

import ai.grakn.Grakn;
import ai.grakn.GraknSession;
import ai.grakn.engine.GraknEngineServer;
import ai.grakn.engine.tasks.TaskManager;
import ai.grakn.engine.tasks.manager.StandaloneTaskManager;
import ai.grakn.engine.tasks.manager.singlequeue.SingleQueueTaskManager;
import ai.grakn.engine.tasks.mock.MockBackgroundTask;
import ai.grakn.engine.util.ExceptionWrapper;
import ai.grakn.test.GraknTestEnv;
import org.junit.rules.ExternalResource;

public class EngineContext
extends ExternalResource {
    private GraknEngineServer server;
    private final boolean startKafka;
    private final boolean startSingleQueueEngine;
    private final boolean startStandaloneEngine;
    private int port = 4567;

    private EngineContext(boolean startKafka, boolean startSingleQueueEngine, boolean startStandaloneEngine) {
        this.startSingleQueueEngine = startSingleQueueEngine;
        this.startStandaloneEngine = startStandaloneEngine;
        this.startKafka = startKafka;
    }

    public static EngineContext startKafkaServer() {
        return new EngineContext(true, false, false);
    }

    public static EngineContext startSingleQueueServer() {
        return new EngineContext(true, true, false);
    }

    public static EngineContext startInMemoryServer() {
        return new EngineContext(false, false, true);
    }

    public EngineContext port(int port) {
        this.port = port;
        return this;
    }

    public GraknEngineServer server() {
        return this.server;
    }

    public TaskManager getTaskManager() {
        return this.server.getTaskManager();
    }

    public GraknSession factoryWithNewKeyspace() {
        return Grakn.session((String)("localhost:" + this.port), (String)GraknTestEnv.randomKeyspace());
    }

    public void before() throws Throwable {
        if (this.startKafka) {
            GraknTestEnv.startKafka();
        }
        GraknTestEnv.startRedis();
        if (this.startSingleQueueEngine) {
            this.server = GraknTestEnv.startEngine(SingleQueueTaskManager.class.getName(), this.port);
        }
        if (this.startStandaloneEngine) {
            this.server = GraknTestEnv.startEngine(StandaloneTaskManager.class.getName(), this.port);
        }
    }

    public void after() {
        ExceptionWrapper.noThrow(MockBackgroundTask::clearTasks, (String)"Error clearing tasks");
        try {
            if (this.startSingleQueueEngine | this.startStandaloneEngine) {
                ExceptionWrapper.noThrow(() -> GraknTestEnv.stopEngine(this.server), (String)"Error closing engine");
            }
            if (this.startKafka) {
                ExceptionWrapper.noThrow(GraknTestEnv::stopKafka, (String)"Error stopping kafka");
            }
            GraknTestEnv.stopRedis();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not shut down ", e);
        }
    }
}

