/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test;

import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.engine.GraknEngineConfig;
import ai.grakn.engine.GraknEngineServer;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.engine.tasks.TaskState;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import com.jayway.restassured.RestAssured;
import info.batey.kafka.unit.KafkaUnit;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisServer;

public abstract class GraknTestEnv {
    private static final Logger LOG = LoggerFactory.getLogger(GraknTestEnv.class);
    private static final GraknEngineConfig properties = GraknEngineConfig.getInstance();
    private static String CONFIG = System.getProperty("grakn.test-profile");
    private static AtomicBoolean CASSANDRA_RUNNING = new AtomicBoolean(false);
    private static AtomicInteger KAFKA_COUNTER = new AtomicInteger(0);
    private static AtomicInteger REDIS_COUNTER = new AtomicInteger(0);
    private static KafkaUnit kafkaUnit = new KafkaUnit(2181, 9092);
    private static RedisServer redisServer;

    public static void ensureCassandraRunning() throws Exception {
        if (CASSANDRA_RUNNING.compareAndSet(false, true) && GraknTestEnv.usingTitan()) {
            LOG.info("starting cassandra...");
            GraknTestEnv.startEmbeddedCassandra();
            LOG.info("cassandra started.");
        }
    }

    static GraknEngineServer startEngine(String taskManagerClass, int port) throws Exception {
        LOG.info("starting engine...");
        GraknTestEnv.ensureCassandraRunning();
        RestAssured.baseURI = "http://" + properties.getProperty("server.host") + ":" + properties.getProperty("server.port");
        GraknEngineServer server = GraknEngineServer.start((String)taskManagerClass, (int)port);
        LOG.info("engine started.");
        return server;
    }

    static void startRedis() throws IOException {
        if (REDIS_COUNTER.getAndIncrement() == 0) {
            LOG.info("Starting redis...");
            redisServer = new RedisServer(Integer.valueOf(properties.getPropertyAsInt("redis.port")));
            redisServer.start();
            LOG.info("Redis started.");
        }
    }

    static void startKafka() throws Exception {
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.ERROR);
        if (KAFKA_COUNTER.getAndIncrement() == 0) {
            LOG.info("Starting kafka...");
            kafkaUnit.setKafkaBrokerConfig("log.cleaner.enable", "false");
            kafkaUnit.startup();
            kafkaUnit.createTopic(TaskState.Priority.HIGH.queue(), Integer.valueOf(properties.getAvailableThreads() * 2));
            kafkaUnit.createTopic(TaskState.Priority.LOW.queue(), Integer.valueOf(properties.getAvailableThreads() * 2));
            LOG.info("Kafka started.");
        }
    }

    static void stopKafka() throws Exception {
        if (KAFKA_COUNTER.decrementAndGet() == 0) {
            LOG.info("Stopping kafka...");
            kafkaUnit.shutdown();
            LOG.info("Kafka stopped.");
        }
    }

    static void stopRedis() {
        if (REDIS_COUNTER.decrementAndGet() == 0) {
            LOG.info("Stopping Redis...");
            redisServer.stop();
            LOG.info("Redis stopped.");
        }
    }

    static void stopEngine(GraknEngineServer server) throws Exception {
        LOG.info("stopping engine...");
        server.close();
        GraknTestEnv.clearGraphs();
        LOG.info("engine stopped.");
    }

    private static void clearGraphs() {
        EngineGraknGraphFactory engineGraknGraphFactory = EngineGraknGraphFactory.getInstance();
        try (GraknGraph systemGraph = engineGraknGraphFactory.getGraph("graknSystem", GraknTxType.WRITE);){
            ((List)systemGraph.graql().match(new Pattern[]{Graql.var((String)"x").isa("keyspace-name")}).execute()).forEach(x -> x.values().forEach(y -> {
                String name = y.asResource().getValue().toString();
                GraknGraph graph = engineGraknGraphFactory.getGraph(name, GraknTxType.WRITE);
                graph.clear();
                graph.admin().commitNoLogs();
            }));
        }
        engineGraknGraphFactory.refreshConnections();
    }

    static void startEmbeddedCassandra() {
        try {
            Class<?> cl = Class.forName("org.cassandraunit.utils.EmbeddedCassandraServerHelper");
            cl.getMethod("startEmbeddedCassandra", String.class).invoke(null, "cassandra-embedded.yaml");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                LOG.info("Thread sleep interrupted.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String randomKeyspace() {
        return "a" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean usingTinker() {
        return "tinker".equals(CONFIG);
    }

    public static boolean usingTitan() {
        return "titan".equals(CONFIG);
    }

    public static boolean usingOrientDB() {
        return "orientdb".equals(CONFIG);
    }
}

