/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test;

import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.test.GraknTestEnv;
import ai.grakn.test.graphs.TestGraph;
import java.util.function.Consumer;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class GraphContext
implements TestRule {
    private GraknGraph graph;
    private String keyspace;
    private Consumer<GraknGraph> preLoad;
    private String[] files;
    private boolean assumption = true;

    private GraphContext(Consumer<GraknGraph> build, String[] files) {
        this.preLoad = build;
        this.files = files;
        this.keyspace = GraknTestEnv.randomKeyspace();
    }

    public static GraphContext empty() {
        return new GraphContext(null, null);
    }

    public static GraphContext preLoad(Consumer<GraknGraph> build) {
        return new GraphContext(build, null);
    }

    public static GraphContext preLoad(String ... filesToLoad) {
        return new GraphContext(null, filesToLoad);
    }

    public GraphContext assumeTrue(boolean bool) {
        this.assumption = bool;
        return this;
    }

    public GraknGraph graph() {
        if (this.graph.isClosed()) {
            this.graph = this.getEngineGraph();
        }
        return this.graph;
    }

    public void rollback() {
        if (GraknTestEnv.usingTinker()) {
            this.graph.clear();
            this.graph.admin().commitNoLogs();
            this.loadGraph();
        } else if (!this.graph.isClosed()) {
            this.graph.close();
        }
        this.graph = this.getEngineGraph();
    }

    public void load(Consumer<GraknGraph> build) {
        this.preLoad = build;
        this.loadGraph();
    }

    private GraknGraph getEngineGraph() {
        return EngineGraknGraphFactory.getInstance().getGraph(this.keyspace, GraknTxType.WRITE);
    }

    private void loadGraph() {
        try (GraknGraph graph = this.getEngineGraph();){
            if (this.preLoad != null) {
                this.preLoad.accept(graph);
            }
            if (this.files != null) {
                for (String file : this.files) {
                    TestGraph.loadFromFile(graph, file);
                }
            }
            graph.admin().commitNoLogs();
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Assume.assumeTrue((boolean)GraphContext.this.assumption);
                GraknTestEnv.ensureCassandraRunning();
                GraphContext.this.loadGraph();
                try (GraknGraph graph = GraphContext.this.getEngineGraph();){
                    GraphContext.this.graph = graph;
                    base.evaluate();
                }
            }
        };
    }
}

