/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.engine.tasks;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.TaskConfiguration;
import ai.grakn.engine.tasks.TaskSchedule;
import ai.grakn.engine.tasks.TaskState;
import ai.grakn.engine.tasks.TaskStateStorage;
import ai.grakn.engine.tasks.mock.FailingMockTask;
import ai.grakn.engine.tasks.mock.ShortExecutionMockTask;
import ai.grakn.engine.util.EngineID;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTaskTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTaskTestUtils.class);

    public static Set<TaskState> createRunningTasks(int n, EngineID engineID) {
        return Stream.generate(() -> BackgroundTaskTestUtils.createTask(ShortExecutionMockTask.class).markRunning(engineID)).limit(n).collect(Collectors.toSet());
    }

    public static TaskConfiguration configuration(TaskState taskState) {
        return TaskConfiguration.of((Json)Json.object((Object[])new Object[]{"id", taskState.getId().getValue()}));
    }

    public static TaskState createTask() {
        return BackgroundTaskTestUtils.createTask(ShortExecutionMockTask.class);
    }

    public static TaskState createTask(Class<? extends BackgroundTask> clazz) {
        return BackgroundTaskTestUtils.createTask(clazz, TaskSchedule.now());
    }

    public static TaskState createTask(Class<? extends BackgroundTask> clazz, TaskSchedule schedule) {
        return TaskState.of(clazz, (String)BackgroundTaskTestUtils.class.getName(), (TaskSchedule)schedule, (TaskState.Priority)TaskState.Priority.LOW);
    }

    public static void waitForDoneStatus(TaskStateStorage storage, Collection<TaskState> tasks) {
        BackgroundTaskTestUtils.waitForStatus(storage, tasks, TaskStatus.COMPLETED, TaskStatus.FAILED, TaskStatus.STOPPED);
    }

    public static void waitForStatus(TaskStateStorage storage, Collection<TaskState> tasks, TaskStatus ... status) {
        HashSet statusSet = Sets.newHashSet((Object[])status);
        tasks.forEach(t -> BackgroundTaskTestUtils.waitForStatus(storage, t, (Set<TaskStatus>)statusSet));
    }

    private static void waitForStatus(TaskStateStorage storage, TaskState task, Set<TaskStatus> status) {
        BackgroundTaskTestUtils.waitForStatus(storage, task.getId(), status);
    }

    public static void waitForStatus(TaskStateStorage storage, TaskId task, Set<TaskStatus> status) {
        Instant initial = Instant.now();
        while (true) {
            TaskStatus currentStatus;
            long duration;
            if ((duration = Duration.between(initial, Instant.now()).toMillis()) > 120000L) {
                TaskStatus finalStatus = storage.containsTask(task) ? storage.getState(task).status() : null;
                LOG.warn("Waiting for status of " + task + " to be any of " + status + ", but status is " + finalStatus);
                initial = Instant.now();
            }
            if (storage.containsTask(task) && status.contains(currentStatus = storage.getState(task).status())) {
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static Multiset<TaskId> completableTasks(List<TaskState> tasks) {
        Map<TaskId, Long> tasksById = tasks.stream().collect(Collectors.groupingBy(TaskState::getId, Collectors.counting()));
        Set retriedTasks = Maps.filterValues(tasksById, count -> count != null && count > 1L).keySet();
        HashSet completableTasks = Sets.newHashSet();
        HashSet visitedTasks = Sets.newHashSet();
        HashSet appearedTasks = Sets.newHashSet();
        tasks.forEach(task -> {
            TaskId id = task.getId();
            boolean visited = visitedTasks.contains(id);
            boolean willFail = task.taskClass().equals(FailingMockTask.class);
            boolean isRunning = appearedTasks.contains(id);
            boolean isRetried = retriedTasks.contains(id);
            if (!(visited || !isRunning && isRetried)) {
                if (!willFail) {
                    completableTasks.add(id);
                }
                visitedTasks.add(id);
            }
            appearedTasks.add(id);
        });
        return ImmutableMultiset.copyOf((Iterable)completableTasks);
    }

    public static Set<TaskId> failingTasks(List<TaskState> tasks) {
        Multiset<TaskId> completableTasks = BackgroundTaskTestUtils.completableTasks(tasks);
        return tasks.stream().map(TaskState::getId).filter(task -> !completableTasks.contains(task)).collect(Collectors.toSet());
    }
}

