/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.graphs;

import ai.grakn.GraknGraph;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.RuleType;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.test.graphs.TestGraph;
import java.util.Collection;
import java.util.function.Consumer;

public class AbstractGraph
extends TestGraph {
    private static ResourceType<String> key;
    private static EntityType P;
    private static EntityType Q;
    private static EntityType p;
    private static EntityType q;
    private static EntityType r;
    private static EntityType s;
    private static EntityType t;
    private static EntityType u;
    private static RelationType rel;
    private static RelationType REL;
    private static RoleType relRoleA;
    private static RoleType relRoleB;
    private static RoleType RELRoleA;
    private static RoleType RELRoleB;
    private static Instance instanceU;
    private static Instance instanceT;
    private static Instance instanceP;

    public static Consumer<GraknGraph> get() {
        return new AbstractGraph().build();
    }

    @Override
    protected void buildOntology(GraknGraph graph) {
        key = graph.putResourceType("name", ResourceType.DataType.STRING);
        relRoleA = graph.putRoleType("rel-roleA");
        relRoleB = graph.putRoleType("rel-roleB");
        rel = graph.putRelationType("rel").relates(relRoleA).relates(relRoleB);
        RELRoleA = graph.putRoleType("REL-roleA");
        RELRoleB = graph.putRoleType("REL-roleB");
        REL = graph.putRelationType("REL").relates(RELRoleA).relates(RELRoleB);
        P = graph.putEntityType("P").plays(RELRoleA).plays(RELRoleB);
        P.resource(key);
        Q = graph.putEntityType("Q").plays(RELRoleB).plays(RELRoleA);
        p = graph.putEntityType("p").plays(relRoleA).plays(RELRoleA);
        q = graph.putEntityType("q").plays(relRoleB).plays(RELRoleB);
        r = graph.putEntityType("r").plays(relRoleA).plays(RELRoleA);
        s = graph.putEntityType("s").plays(relRoleB).plays(RELRoleB);
        u = graph.putEntityType("u").plays(relRoleA).plays(RELRoleA);
        u.resource(key);
        t = graph.putEntityType("t").plays(relRoleB).plays(RELRoleB);
        t.resource(key);
    }

    @Override
    protected void buildInstances(GraknGraph graph) {
        instanceU = AbstractGraph.putEntity(graph, "instanceU", u, key.getLabel());
        instanceT = AbstractGraph.putEntity(graph, "instanceT", t, key.getLabel());
        instanceP = AbstractGraph.putEntity(graph, "instanceP", P, key.getLabel());
    }

    @Override
    protected void buildRelations(GraknGraph graph) {
        rel.addRelation().addRolePlayer(relRoleA, instanceU).addRolePlayer(relRoleB, instanceT);
        REL.addRelation().addRolePlayer(RELRoleA, instanceU).addRolePlayer(RELRoleB, instanceP);
    }

    @Override
    protected void buildRules(GraknGraph graph) {
        RuleType inferenceRule = graph.admin().getMetaRuleInference();
        Pattern R1_LHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa p;$y isa q;($x, $y) isa rel;"));
        Pattern R1_RHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa Q;"));
        inferenceRule.putRule(R1_LHS, R1_RHS);
        Pattern R2_LHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa r;"));
        Pattern R2_RHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa p;"));
        inferenceRule.putRule(R2_LHS, R2_RHS);
        Pattern R3_LHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa s;"));
        Pattern R3_RHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa p;"));
        inferenceRule.putRule(R3_LHS, R3_RHS);
        Pattern R4_LHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa t;"));
        Pattern R4_RHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa q;"));
        inferenceRule.putRule(R4_LHS, R4_RHS);
        Pattern R5_LHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa u;"));
        Pattern R5_RHS = Graql.and((Collection)graph.graql().parsePatterns("$x isa r;"));
        inferenceRule.putRule(R5_LHS, R5_RHS);
    }
}

