/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.graphs;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeLabel;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.graql.Query;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class TestGraph {
    protected void buildOntology(GraknGraph graph) {
    }

    protected void buildInstances(GraknGraph graph) {
    }

    protected void buildRelations(GraknGraph graph) {
    }

    protected void buildRules(GraknGraph graph) {
    }

    public Consumer<GraknGraph> build() {
        return graph -> {
            this.buildOntology((GraknGraph)graph);
            this.buildInstances((GraknGraph)graph);
            this.buildRelations((GraknGraph)graph);
            this.buildRules((GraknGraph)graph);
        };
    }

    public static Instance putEntity(GraknGraph graph, String id, EntityType type, TypeLabel key) {
        Entity inst = type.addEntity();
        TestGraph.putResource((Instance)inst, (ResourceType)graph.getType(key), id);
        return inst;
    }

    public static <T> void putResource(Instance instance, ResourceType<T> resourceType, T resource) {
        Resource resourceInstance = resourceType.putResource(resource);
        instance.resource(resourceInstance);
    }

    public static Instance getInstance(GraknGraph graph, String id) {
        Set instances = graph.getResourcesByValue((Object)id).stream().flatMap(res -> res.ownerInstances().stream()).collect(Collectors.toSet());
        if (instances.size() != 1) {
            throw new IllegalStateException("Multiple instances with given resource value");
        }
        return (Instance)instances.iterator().next();
    }

    public static void loadFromFile(GraknGraph graph, String file) {
        try {
            File graql = new File("src/test/graql/" + file);
            graph.graql().parseList(Files.readLines((File)graql, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"))).forEach(Query::execute);
        }
        catch (GraknValidationException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

