package ai.grakn.kgms.console.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Command {

    final public void handle(String command) {
        Matcher matcher = pattern().matcher(command);
        boolean matches = matcher.matches();
        if (matches) {
            handleParsed(command, matcher);
        } else {
            throw new CommandNotMatchedException();
        }
    }

    final public boolean recognize(String command) {
        return pattern().matcher(command).matches();
    }

    protected abstract Pattern pattern();

    protected abstract void handleParsed(String command, Matcher matcher);

}
