package ai.grakn.kgms.console.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CommandBus {


    private final NotRecognised unrecognized;
    private final List<Command> commands;

    public CommandBus(NotRecognised unrecognized, Command... commands) {
        this.unrecognized = unrecognized;
        this.commands = Arrays.asList(commands);
    }

    public void run(String command) {
        Optional<Command> cmdc = commands.stream()
                .filter((cmd) -> cmd.recognize(command)).findAny();
        if (cmdc.isPresent()) {
            cmdc.get().handle(command);
        } else {
            unrecognized.handle(command);
        }
    }
}
