package ai.grakn.kgms.console.command.createuser;

import ai.grakn.kgms.console.command.Command;
import ai.grakn.kgms.console.rpc.UserManagementClient;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateUserCommand extends Command {

    private final Pattern pattern = Pattern.compile(
            "\\s*CREATE USER\\s+([0-9a-zA-Z]+)\\s+" +
                    "WITH PASSWORD\\s+([0-9a-zA-Z]+)\\s*"// + "WITH ROLE\\s+([a-z]+)\\s*" re-enable when adding Authorisation
            , Pattern.CASE_INSENSITIVE
    );

    private final UserManagementClient client;
    private final CreateUserDisplay display;

    public CreateUserCommand(UserManagementClient client, CreateUserDisplay display) {
        this.client = client;
        this.display = display;
    }

    @Override
    protected void handleParsed(String command, Matcher matcher) {
        String username = matcher.group(1);
        String password = matcher.group(2);
        String role = "admin";//TODO: re-enable this when adding Authorisation -> matcher.group(3);
        client.create(username, password, role);
        display.created();
    }

    @Override
    protected Pattern pattern() {
        return pattern;
    }
}
