package ai.grakn.kgms.console.command.deleteuser;

import ai.grakn.kgms.console.command.Command;
import ai.grakn.kgms.console.rpc.UserManagementClient;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeleteUserCommand extends Command {

    private final Pattern pattern = Pattern.compile("\\s*DELETE USER\\s+([0-9a-zA-Z]+)\\s*", Pattern.CASE_INSENSITIVE);
    private final DeleteUserDisplay display;
    private final UserManagementClient client;

    public DeleteUserCommand(UserManagementClient client, DeleteUserDisplay display) {
        this.client = client;
        this.display = display;
    }

    @Override
    protected Pattern pattern() {
        return pattern;
    }

    @Override
    protected void handleParsed(String command, Matcher matcher) {
        String username = matcher.group(1);
        client.delete(username);
        display.deleted();
    }

}
