package ai.grakn.kgms.console.command.retrieveallusers;

import ai.grakn.kgms.authentication.model.User;
import ai.grakn.kgms.console.command.Command;
import ai.grakn.kgms.console.rpc.UserManagementClient;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RetrieveAllUserCommand extends Command {

    private final Pattern pattern = Pattern.compile("\\s*LIST USERS\\s*", Pattern.CASE_INSENSITIVE);

    private final UserManagementClient client;
    private final RetrieveAllUserDisplay display;

    public RetrieveAllUserCommand(UserManagementClient client, RetrieveAllUserDisplay display) {
        this.client = client;
        this.display = display;
    }

    @Override
    protected Pattern pattern() { return pattern; }

    @Override
    protected void handleParsed(String command, Matcher matcher) {
        List<User> users = client.retrieveAll();
        display.retrieved(users);
    }
}
