/*
 * Grakn - A Distributed Semantic Database
 * Copyright (C) 2016  Grakn Labs Limited
 *
 * Grakn is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Grakn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Grakn. If not, see <http://www.gnu.org/licenses/gpl.txt>.
 */
package ai.grakn.kgms.console.command.retrieveallusers;

import ai.grakn.kgms.authentication.model.User;

import java.io.PrintWriter;
import java.util.List;

public class RetrieveAllUserDisplay {

    private final PrintWriter output;

    public RetrieveAllUserDisplay(PrintWriter output) {
        this.output = output;
    }

    void retrieved(List<User> users) {
        String leftAlignFormat = "| %-15s | %-5s |%n";
        output.format("+-----------------+--------+%n");
        output.format("| Username        |  Role  |%n");
        output.format("+-----------------+--------+%n");
        for(User user : users){
            output.format(leftAlignFormat, user.username(), user.role());
        }
        output.format("+-----------------+--------+%n");
    }
}
