/*
 * Grakn - A Distributed Semantic Database
 * Copyright (C) 2016  Grakn Labs Limited
 *
 * Grakn is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Grakn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Grakn. If not, see <http://www.gnu.org/licenses/gpl.txt>.
 */
package ai.grakn.kgms.console.command.retrieveuser;

import ai.grakn.kgms.authentication.model.User;
import ai.grakn.kgms.console.command.Command;
import ai.grakn.kgms.console.rpc.UserManagementClient;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RetrieveUserCommand extends Command {

    private final Pattern pattern = Pattern.compile("\\s*GET USER\\s+([0-9a-zA-Z]+)\\s*", Pattern.CASE_INSENSITIVE);

    private final UserManagementClient client;
    private final RetrieveUserDisplay display;

    public RetrieveUserCommand(UserManagementClient client, RetrieveUserDisplay display) {
        this.client = client;
        this.display = display;
    }

    @Override
    protected Pattern pattern() {
        return pattern;
    }

    @Override
    protected void handleParsed(String command, Matcher matcher) {
        String username = matcher.group(1);
        User user = client.retrieve(username);
        display.retrieved(user);
    }
}
