package ai.grakn.kgms.console.command.updateuser;

import ai.grakn.kgms.console.command.Command;
import ai.grakn.kgms.console.rpc.UserManagementClient;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpdateUserCommand extends Command {

    // TODO: re enable this when adding Authorisation
//    private static final String UPDATE_USER = "\\s*UPDATE USER\\s+(?<username>[0-9a-zA-Z]+)";
//    // Update only user password
//    private static final String WITH_PASS = "(\\s+WITH PASSWORD\\s+([0-9a-zA-Z]+))";
//    // Update only user role
//    private static final String WITH_ROLE = "(\\s+WITH ROLE\\s+([0-9a-zA-Z]+)\\s*)";
//    // Update user password and role
//    private static final String WITH_PASS_OR_ROLE = "(?<roleandpassword>" + WITH_PASS + WITH_ROLE + ")" + "|" + "(?<rolegroup>" + WITH_ROLE + ")" + "|" + "(?<passwordgroup>" + WITH_PASS + ")";
//
//    // This regex checks that the update user command has update of password or role or both.
//    private final Pattern pattern = Pattern.compile("^" + UPDATE_USER + "(" + WITH_PASS_OR_ROLE + ")\\s*$", Pattern.CASE_INSENSITIVE);
    private final Pattern pattern = Pattern.compile(
            "\\s*UPDATE USER\\s+([0-9a-zA-Z]+)\\s+" +
                    "WITH PASSWORD\\s+([0-9a-zA-Z]+)\\s*"
            , Pattern.CASE_INSENSITIVE
    );

    private final UserManagementClient client;
    private final UpdateUserDisplay display;

    public UpdateUserCommand(UserManagementClient client, UpdateUserDisplay display) {
        this.client = client;
        this.display = display;
    }

    @Override
    protected void handleParsed(String command, Matcher matcher) {
//        String username = matcher.group("username");
//        String password = null;
//        String role = null;
//
//        if (matcher.group("roleandpassword") != null) {
//            password = matcher.group(5);
//            role = matcher.group(7);
//        } else if (matcher.group("rolegroup") != null) {
//            role = matcher.group(10);
//        } else if (matcher.group("passwordgroup") != null) {
//            password = matcher.group(13);
//        }
        String username = matcher.group(1);
        String password = matcher.group(2);
        client.update(username, password, null);
        display.updated();
    }

    @Override
    protected Pattern pattern() {
        return pattern;
    }
}
