package ai.grakn.kgms.console.rpc;

import ai.grakn.kgms.rpc.generated.KGMSConsoleProto;
import io.grpc.stub.StreamObserver;

import java.util.concurrent.BlockingQueue;

public class ResponseListener implements StreamObserver<KGMSConsoleProto.UserManagement.Res> {


    private final BlockingQueue<GrpcResponse> queue;

    public ResponseListener(BlockingQueue<GrpcResponse> queue) {
        this.queue = queue;
    }

    @Override
    public synchronized void onNext(KGMSConsoleProto.UserManagement.Res res) {
        queue.add(new GrpcResponse(res));
    }

    @Override
    public void onError(Throwable throwable) {
        queue.add(new GrpcResponse(throwable));
    }

    @Override
    public void onCompleted() {
        queue.add(new GrpcResponse());
    }

    public GrpcResponse getResponse() throws InterruptedException {
       return queue.take();
    }
}
