/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.client.Client;
import ai.grakn.concept.Label;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.VarPattern;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.base.Migrator;
import ai.grakn.util.Schema;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.HelpFormatter;
import org.yaml.snakeyaml.Yaml;

public class MigrationCLI {
    private static final String COULD_NOT_CONNECT = "Could not connect to Grakn Engine. Have you run 'grakn.sh start'?";

    public static <T extends MigrationOptions> List<Optional<T>> init(String[] args, Function<String[], T> constructor) {
        try {
            MigrationOptions baseOptions = (MigrationOptions)constructor.apply(args);
            if (baseOptions.getConfiguration() != null) {
                return MigrationCLI.extractOptionsFromConfiguration(baseOptions.getConfiguration(), args).stream().map(constructor).map(MigrationCLI::validate).collect(Collectors.toList());
            }
            return Collections.singletonList(MigrationCLI.validate(baseOptions));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return Collections.emptyList();
        }
    }

    private static <T extends MigrationOptions> Optional<T> validate(T options) {
        if (options.isHelp()) {
            MigrationCLI.printHelpMessage(options);
            return Optional.empty();
        }
        if (options.getNumberOptions() == 0) {
            MigrationCLI.printHelpMessage(options);
            return Optional.empty();
        }
        if (!Client.serverIsRunning((String)options.getUri())) {
            System.err.println(COULD_NOT_CONNECT);
            return Optional.empty();
        }
        return Optional.of(options);
    }

    public static void loadOrPrint(File templateFile, Stream<Map<String, Object>> data, MigrationOptions options) {
        String template = MigrationCLI.fileAsString(templateFile);
        Migrator migrator = Migrator.to(options.getUri(), options.getKeyspace());
        if (options.isNo()) {
            migrator.print(template, data);
        } else {
            MigrationCLI.printInitMessage(options);
            migrator.load(template, data, options.getBatch(), options.getNumberActiveTasks(), options.getRetry());
            MigrationCLI.printWholeCompletionMessage(options);
        }
    }

    public static void printInitMessage(MigrationOptions options) {
        System.out.println("Migrating data " + (options.hasInput() ? options.getInput() : "") + " using Grakn Engine " + options.getUri() + " into graph " + options.getKeyspace());
    }

    public static void printWholeCompletionMessage(MigrationOptions options) {
        System.out.println("Migration complete.");
        if (options.isVerbose()) {
            System.out.println("Gathering information about migrated data. If in a hurry, you can ctrl+c now.");
            GraknGraph graph = Grakn.session((String)options.getUri(), (String)options.getKeyspace()).open(GraknTxType.WRITE);
            QueryBuilder qb = graph.graql();
            StringBuilder builder = new StringBuilder();
            builder.append("Graph ontology contains:\n");
            builder.append("\t ").append(graph.admin().getMetaEntityType().instances().size()).append(" entity types\n");
            builder.append("\t ").append(graph.admin().getMetaRelationType().instances().size()).append(" relation types\n");
            builder.append("\t ").append("0 role types\n");
            builder.append("\t ").append(graph.admin().getMetaResourceType().instances().size()).append(" resource types\n");
            builder.append("\t ").append(graph.admin().getMetaRuleType().instances().size()).append(" rule types\n\n");
            builder.append("Graph data contains:\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa((VarPattern)Graql.var((String)"y")), Graql.var((String)"y").sub(Graql.label((Label)Schema.MetaSchema.ENTITY.getLabel()))}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" entities\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa((VarPattern)Graql.var((String)"y")), Graql.var((String)"y").sub(Graql.label((Label)Schema.MetaSchema.RELATION.getLabel()))}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" relations\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa((VarPattern)Graql.var((String)"y")), Graql.var((String)"y").sub(Graql.label((Label)Schema.MetaSchema.RESOURCE.getLabel()))}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" resources\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa((VarPattern)Graql.var((String)"y")), Graql.var((String)"y").sub(Graql.label((Label)Schema.MetaSchema.RULE.getLabel()))}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" rules\n\n");
            System.out.println(builder);
            graph.close();
        }
    }

    private static String fileAsString(File file) {
        try {
            return Files.readLines((File)file, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file " + file.getPath(), e);
        }
    }

    private static void printHelpMessage(MigrationOptions options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        int width = helpFormatter.getWidth();
        int leftPadding = helpFormatter.getLeftPadding();
        int descPadding = helpFormatter.getDescPadding();
        helpFormatter.printHelp(printWriter, width, "migration.sh", null, options.getOptions(), leftPadding, descPadding, null);
        printWriter.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String[]> extractOptionsFromConfiguration(String path, String[] args) {
        File configuration = new File(path);
        if (!configuration.exists()) {
            throw new RuntimeException("Could not find configuration file " + path);
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configuration), Charset.defaultCharset());){
            List config = (List)new Yaml().load((Reader)reader);
            ArrayList<String[]> options = new ArrayList<String[]>();
            for (Map c : config) {
                ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
                c.entrySet().stream().flatMap(m -> Stream.of("-" + (String)m.getKey(), (String)m.getValue())).forEach(parameters::add);
                options.add(parameters.toArray(new String[parameters.size()]));
            }
            ArrayList<String[]> arrayList = options;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse configuration file.");
        }
    }
}

