/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MigrationOptions {
    private static final String batch = Integer.toString(25);
    private static final String active = Integer.toString(25);
    private int numberOptions;
    protected final Options options = new Options();
    protected CommandLine command;

    public MigrationOptions() {
        this.options.addOption("v", "verbose", false, "Print counts of migrated data.");
        this.options.addOption("h", "help", false, "Print usage message.");
        this.options.addOption("k", "keyspace", true, "Grakn graph. Required.");
        this.options.addOption("u", "uri", true, "Location of Grakn Engine.");
        this.options.addOption("n", "no", false, "Write to standard out.");
        this.options.addOption("c", "config", true, "Configuration file.");
        this.options.addOption("r", "retry", true, "Retry sending tasks if engine is not available");
    }

    public boolean isVerbose() {
        return this.command.hasOption("v");
    }

    public boolean isHelp() {
        return this.command.hasOption("h");
    }

    public boolean isNo() {
        return this.command.hasOption("n");
    }

    public String getKeyspace() {
        if (!this.command.hasOption("k")) {
            throw new IllegalArgumentException("Keyspace missing (-k)");
        }
        return this.command.getOptionValue("k");
    }

    @Nullable
    public String getConfiguration() {
        return this.command.hasOption("c") ? this.command.getOptionValue("c") : null;
    }

    public String getUri() {
        return this.command.hasOption("u") ? this.command.getOptionValue("u") : "localhost:4567";
    }

    public Options getOptions() {
        return this.options;
    }

    public int getNumberOptions() {
        return this.numberOptions;
    }

    public String getInput() {
        if (!this.command.hasOption("i")) {
            throw new IllegalArgumentException("Data file missing (-i)");
        }
        return this.resolvePath(this.command.getOptionValue("i"));
    }

    public boolean hasInput() {
        return this.command.hasOption("i");
    }

    public String getTemplate() {
        if (!this.command.hasOption("t")) {
            throw new IllegalArgumentException("Template file missing (-t)");
        }
        return this.resolvePath(this.command.getOptionValue("t"));
    }

    public boolean getRetry() {
        return this.command.hasOption("r") && Boolean.getBoolean(this.command.getOptionValue("r"));
    }

    public int getBatch() {
        return Integer.parseInt(this.command.getOptionValue("b", batch));
    }

    public int getNumberActiveTasks() {
        return Integer.parseInt(this.command.getOptionValue("a", active));
    }

    protected void parse(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            this.command = parser.parse(this.options, args);
            this.numberOptions = this.command.getOptions().length;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolvePath(String path) {
        Path givenPath = Paths.get(path, new String[0]);
        if (givenPath.isAbsolute()) {
            return givenPath.toAbsolutePath().toString();
        }
        return Paths.get("", new String[0]).toAbsolutePath().resolve(givenPath).toString();
    }
}

