/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.Keyspace;
import ai.grakn.client.BatchMutatorClient;
import ai.grakn.client.TaskResult;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Query;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.macro.Macro;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final AtomicInteger numberQueriesSubmitted = new AtomicInteger(0);
    private static final AtomicInteger numberBatchesCompleted = new AtomicInteger(0);
    private static final Logger LOG = LoggerFactory.getLogger(Migrator.class);
    private final QueryBuilderImpl queryBuilder = (QueryBuilderImpl)Graql.withoutGraph().infer(false);
    public static final int BATCH_SIZE = 25;
    public static final int ACTIVE_TASKS = 16;
    public static final int DEFAULT_MAX_RETRY = 1;
    private final String uri;
    private final Keyspace keyspace;
    private int batchSize;
    private long startTime;

    private Migrator(String uri, Keyspace keyspace) {
        this.uri = uri;
        this.keyspace = keyspace;
    }

    public static Migrator to(String uri, Keyspace keyspace) {
        return new Migrator(uri, keyspace);
    }

    public Migrator registerMacro(Macro macro) {
        this.queryBuilder.registerMacro(macro);
        return this;
    }

    public void load(String template, Stream<Map<String, Object>> converter) {
        this.load(template, converter, 25, 16, 1, true);
    }

    public void print(String template, Stream<Map<String, Object>> converter) {
        converter.flatMap(d -> this.template(template, (Map<String, Object>)d)).forEach(System.out::println);
    }

    public void load(String template, Stream<Map<String, Object>> converter, int batchSize, int numberActiveTasks, int retrySize, boolean debug) {
        this.startTime = System.currentTimeMillis();
        this.batchSize = batchSize;
        BatchMutatorClient loader = new BatchMutatorClient(this.keyspace, this.uri, this.recordMigrationStates(), true, debug, retrySize);
        loader.setBatchSize(batchSize);
        loader.setNumberActiveTasks(numberActiveTasks);
        loader.setTaskCompletionConsumer(taskResult -> {
            String stackTrace = taskResult.getStackTrace();
            if (stackTrace != null && !stackTrace.isEmpty()) {
                if (debug) {
                    throw GraknBackendException.migrationFailure((String)stackTrace);
                }
                System.err.println(stackTrace);
            }
        });
        converter.flatMap(d -> this.template(template, (Map<String, Object>)d)).forEach(q -> {
            numberQueriesSubmitted.incrementAndGet();
            loader.add(q);
        });
        loader.waitToFinish();
        loader.close();
    }

    protected Stream<Query> template(String template, Map<String, Object> data) {
        try {
            return this.queryBuilder.parseTemplate(template, data);
        }
        catch (GraqlSyntaxException e) {
            LOG.warn("Query not sent to server: " + e.getMessage());
            return Stream.empty();
        }
    }

    private Consumer<TaskResult> recordMigrationStates() {
        return taskId -> {
            numberBatchesCompleted.incrementAndGet();
            long timeElapsedSeconds = (System.currentTimeMillis() - this.startTime) / 1000L;
            long numberQueriesCompleted = numberBatchesCompleted.get() * this.batchSize;
            LOG.info(String.format("Number queries submitted: %s", numberQueriesSubmitted.get()));
            LOG.info(String.format("Number batches completed: %s", numberBatchesCompleted.get()));
            LOG.info(String.format("~Number queries completed: %s", numberQueriesCompleted));
            LOG.info(String.format("~Rate of completion (queries/second): %s", numberQueriesCompleted / timeElapsedSeconds));
        };
    }
}

