/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.csv;

import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.csv.CSVMigrator;

public class CSVMigrationOptions
extends MigrationOptions {
    private final String separator = Character.toString(',');
    private final String quote = Character.toString('\"');
    private final String nullString = CSVMigrator.NULL_STRING;

    public CSVMigrationOptions(String[] args) {
        this.options.addOption("i", "input", true, "Input csv file.");
        this.options.addOption("t", "template", true, "Graql template to apply to the data.");
        this.options.addOption("s", "separator", true, "Separator of columns in input file.");
        this.options.addOption("q", "quote", true, "Character used to encapsulate values containing special characters.");
        this.options.addOption("l", "null", true, "String that will be evaluated as null.");
        this.options.addOption("b", "batch", true, "Number of rows to execute in one Grakn transaction. Default 25.");
        this.options.addOption("a", "active", true, "Number of tasks (batches) running on the server at any one time. Default 25.");
        this.parse(args);
    }

    public char getSeparator() {
        String sep = this.command.getOptionValue("s", this.separator);
        if (sep.toCharArray().length != 1) {
            throw new IllegalArgumentException("Wrong number of characters in quote " + sep);
        }
        return sep.charAt(0);
    }

    public char getQuote() {
        String quo = this.command.getOptionValue("q", this.quote);
        if (quo.toCharArray().length != 1) {
            throw new IllegalArgumentException("Wrong number of characters in quote " + quo);
        }
        return quo.charAt(0);
    }

    public String getNullString() {
        return this.command.getOptionValue("l", this.nullString);
    }
}

