/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.csv;

import ai.grakn.engine.loader.Loader;
import ai.grakn.migration.base.Migrator;
import ai.grakn.migration.base.io.MigrationCLI;
import ai.grakn.migration.base.io.MigrationLoader;
import ai.grakn.migration.csv.CSVMigrator;
import java.io.File;
import org.apache.commons.cli.Options;

public class Main {
    private static Options getOptions() {
        Options options = new Options();
        options.addOption("i", "input", true, "input csv file");
        options.addOption("t", "template", true, "graql template to apply over data");
        options.addOption("s", "separator", true, "separator of columns in input file");
        options.addOption("b", "batch", true, "number of row to load at once");
        return options;
    }

    public static void main(String[] args) {
        MigrationCLI.create((String[])args, (Options)Main.getOptions()).ifPresent(Main::runCSV);
    }

    public static void runCSV(MigrationCLI cli) {
        String delimiterString;
        String csvDataFileName = cli.getRequiredOption("input", "Data file missing (-i)");
        String csvTemplateName = cli.getRequiredOption("template", "Template file missing (-t)");
        int batchSize = cli.hasOption("b") ? Integer.valueOf(cli.getOption("b")) : 25;
        String string = delimiterString = cli.hasOption("s") ? cli.getOption("s") : Character.toString(',');
        if (delimiterString.toCharArray().length != 1) {
            cli.die("Wrong number of characters in delimiter " + delimiterString);
        }
        char csvDelimiter = delimiterString.toCharArray()[0];
        File csvDataFile = new File(csvDataFileName);
        File csvTemplate = new File(csvTemplateName);
        if (!csvTemplate.exists()) {
            cli.die("Cannot find file: " + csvTemplateName);
        }
        if (!csvDataFile.exists()) {
            cli.die("Cannot find file: " + csvDataFileName);
        }
        cli.printInitMessage(csvDataFile.getPath());
        String template = cli.fileAsString(csvTemplate);
        try (CSVMigrator csvMigrator = new CSVMigrator(template, csvDataFile).setSeparator(csvDelimiter);){
            if (cli.hasOption("n")) {
                cli.writeToSout(csvMigrator.migrate());
            } else {
                MigrationLoader.load((Loader)cli.getLoader(), (int)batchSize, (Migrator)csvMigrator);
                cli.printWholeCompletionMessage();
            }
        }
        catch (Throwable throwable) {
            cli.die(throwable);
        }
        cli.initiateShutdown();
    }
}

