/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.csv;

import ai.grakn.graql.InsertQuery;
import ai.grakn.migration.base.AbstractMigrator;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CSVMigrator
extends AbstractMigrator {
    public static final char SEPARATOR = ',';
    private char separator = (char)44;
    private final Reader reader;
    private final String template;

    public CSVMigrator(String template, File file) {
        try {
            this.reader = new FileReader(file);
            this.template = template;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CSVMigrator(String template, Reader reader) {
        this.reader = reader;
        this.template = template;
    }

    public CSVMigrator setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream<InsertQuery> migrate() {
        try (CSVReader csvReader = new CSVReader(this.reader, 0, new CSVParserBuilder().withSeparator(this.separator).withIgnoreLeadingWhiteSpace(true).withEscapeChar('\\').withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build());){
            Iterator it = csvReader.iterator();
            String[] header = (String[])it.next();
            Stream<InsertQuery> stream = this.stream(it).collect(Collectors.toList()).stream().map(col -> this.parse(header, (String[])col)).map(col -> this.template(this.template, (Map)col));
            return stream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> parse(String[] header, String[] data) {
        if (header.length != data.length) {
            throw new RuntimeException("Invalid CSV");
        }
        return IntStream.range(0, header.length).mapToObj(Integer::valueOf).filter(i -> this.validValue(data[i])).collect(Collectors.toMap(i -> header[i], i -> data[i]));
    }
}

