/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.csv;

import ai.grakn.migration.base.MigrationCLI;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.csv.CSVMigrationOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVMigrator
implements AutoCloseable {
    static final char SEPARATOR = ',';
    static final char QUOTE = '\"';
    static final String NULL_STRING = null;
    private char separator = (char)44;
    private char quote = (char)34;
    private String nullString = NULL_STRING;
    private final Reader reader;

    public static void main(String[] args) {
        try {
            MigrationCLI.init((String[])args, CSVMigrationOptions::new).stream().filter(Optional::isPresent).map(Optional::get).forEach(CSVMigrator::runCSV);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void runCSV(CSVMigrationOptions options) {
        File csvDataFile = new File(options.getInput());
        File csvTemplate = new File(options.getTemplate());
        if (!csvTemplate.exists()) {
            throw new IllegalArgumentException("Cannot find file: " + options.getTemplate());
        }
        if (!csvDataFile.exists()) {
            throw new IllegalArgumentException("Cannot find file: " + options.getInput());
        }
        try (CSVMigrator csvMigrator = new CSVMigrator(csvDataFile).setSeparator(options.getSeparator()).setQuoteChar(options.getQuote()).setNullString(options.getNullString());){
            MigrationCLI.loadOrPrint((File)csvTemplate, csvMigrator.convert(), (MigrationOptions)options);
        }
    }

    public CSVMigrator(File file) {
        try {
            this.reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CSVMigrator(Reader reader) {
        this.reader = reader;
    }

    public CSVMigrator setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public CSVMigrator setQuoteChar(char quote) {
        this.quote = quote;
        return this;
    }

    public CSVMigrator setNullString(String nullString) {
        this.nullString = nullString;
        return this;
    }

    public Stream<Map<String, Object>> convert() {
        try {
            CSVParser csvParser = CSVFormat.newFormat((char)this.separator).withIgnoreEmptyLines().withEscape('\\').withFirstRecordAsHeader().withQuote(this.quote).withNullString(this.nullString).parse(this.reader);
            return this.stream(csvParser.iterator()).map(this::parse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> parse(CSVRecord data) {
        if (!data.isConsistent()) {
            throw new RuntimeException("Invalid CSV " + data.toMap());
        }
        return data.toMap().entrySet().stream().filter(e -> this.validValue(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    private boolean validValue(Object value) {
        return value != null;
    }
}

